/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.module.GlobalConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class BottleFluidCapability
implements IFluidHandlerItem,
ICapabilityProvider {
    private static final ResourceLocation KEY = new ResourceLocation("betterwithmods", "bottle");
    @Nonnull
    private ItemStack container;

    private BottleFluidCapability(@Nonnull ItemStack container) {
        this.container = container;
    }

    @SubscribeEvent
    public static void attachCapabilities(@Nonnull AttachCapabilitiesEvent<ItemStack> evt) {
        if (evt.getCapabilities().containsKey(KEY)) {
            return;
        }
        ItemStack stack = (ItemStack)evt.getObject();
        if (stack == null) {
            return;
        }
        if (stack.func_77973_b() == Items.field_151069_bo || stack.func_77973_b() == Items.field_151068_bn) {
            BottleFluidCapability cap = new BottleFluidCapability(stack);
            evt.addCapability(KEY, (ICapabilityProvider)cap);
        }
    }

    private boolean isFull() {
        return this.container.func_77973_b() == Items.field_151068_bn && PotionUtils.func_185191_c((ItemStack)this.container) == PotionTypes.field_185230_b;
    }

    private void fill() {
        this.container = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
    }

    private boolean isEmpty() {
        return this.container.func_77973_b() == Items.field_151069_bo;
    }

    private void empty() {
        this.container = new ItemStack(Items.field_151069_bo);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new IFluidTankProperties(){

            @Nullable
            public FluidStack getContents() {
                return BottleFluidCapability.this.isFull() ? new FluidStack(FluidRegistry.WATER, GlobalConfig.waterBottleAmount) : null;
            }

            public int getCapacity() {
                return GlobalConfig.waterBottleAmount;
            }

            public boolean canFill() {
                return BottleFluidCapability.this.isEmpty();
            }

            public boolean canDrain() {
                return BottleFluidCapability.this.isFull();
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return fluidStack != null && fluidStack.getFluid() == FluidRegistry.WATER;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return fluidStack != null && fluidStack.getFluid() == FluidRegistry.WATER;
            }
        }};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.func_190916_E() != 1 || !this.isEmpty() || resource == null || resource.getFluid() != FluidRegistry.WATER || resource.amount < GlobalConfig.waterBottleAmount) {
            return 0;
        }
        if (doFill) {
            this.fill();
        }
        return GlobalConfig.waterBottleAmount;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || !this.isFull() || resource == null || resource.getFluid() != FluidRegistry.WATER || resource.amount < GlobalConfig.waterBottleAmount) {
            return null;
        }
        if (doDrain) {
            this.empty();
        }
        return new FluidStack(FluidRegistry.WATER, GlobalConfig.waterBottleAmount);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || !this.isFull() || maxDrain < GlobalConfig.waterBottleAmount) {
            return null;
        }
        if (doDrain) {
            this.empty();
        }
        return new FluidStack(FluidRegistry.WATER, GlobalConfig.waterBottleAmount);
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY && (this.isEmpty() || this.isFull());
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(this.hasCapability(capability, facing) ? CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this) : null);
    }
}

