/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.block.managers;

import betterwithmods.common.registry.block.recipe.BlockRecipe;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class CraftingManagerBlock<T extends BlockRecipe> {
    protected final ArrayList<T> recipes = Lists.newArrayList();
    protected HashMap<IBlockState, T> recipeCache = Maps.newHashMap();

    public T addRecipe(T recipe) {
        if (!((BlockRecipe)recipe).isInvalid()) {
            this.recipes.add(recipe);
        }
        return recipe;
    }

    protected List<T> findRecipe(List<ItemStack> outputs) {
        List<T> recipes = this.findRecipeExact(outputs);
        if (recipes.isEmpty()) {
            recipes = this.findRecipeFuzzy(outputs);
        }
        return recipes;
    }

    protected List<T> findRecipeFuzzy(List<ItemStack> outputs) {
        return this.recipes.stream().filter(r -> r.getRecipeOutput().matchesFuzzy(outputs)).collect(Collectors.toList());
    }

    protected List<T> findRecipeExact(List<ItemStack> outputs) {
        return this.recipes.stream().filter(r -> r.getRecipeOutput().matches(outputs)).collect(Collectors.toList());
    }

    protected List<T> findRecipeByInput(ItemStack input) {
        return this.recipes.stream().filter(r -> r.getInput().apply(input)).collect(Collectors.toList());
    }

    public List<T> findRecipes(World world, BlockPos pos, IBlockState state) {
        return this.recipes.stream().filter(r -> r.matches(world, pos, state)).collect(Collectors.toList());
    }

    public Optional<T> findRecipe(World world, BlockPos pos, IBlockState state) {
        BlockRecipe t2;
        if (this.recipeCache.containsKey(state) && (t2 = (BlockRecipe)this.recipeCache.get(state)) != null && t2.matches(world, pos, state)) {
            return Optional.of(t2);
        }
        Optional recipe = this.findRecipes(world, pos, state).stream().findFirst();
        recipe.ifPresent(t -> this.recipeCache.put(state, t));
        return recipe;
    }

    public boolean remove(T t) {
        return t != null && this.recipes.remove(t);
    }

    public boolean remove(List<ItemStack> outputs) {
        return this.recipes.removeAll(this.findRecipe(outputs));
    }

    public boolean removeFuzzy(List<ItemStack> outputs) {
        return this.recipes.removeAll(this.findRecipeFuzzy(outputs));
    }

    public boolean removeExact(List<ItemStack> outputs) {
        return this.recipes.removeAll(this.findRecipeExact(outputs));
    }

    public boolean removeByInput(ItemStack input) {
        return this.recipes.removeAll(this.findRecipeByInput(input));
    }

    public List<T> getRecipes() {
        return this.recipes;
    }

    public List<T> getDisplayRecipes() {
        return this.getRecipes().stream().filter(r -> !r.isHidden()).collect(Collectors.toList());
    }
}

