/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity.ai;

import betterwithmods.module.tweaks.EasyBreeding;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class EntityAISearchFood
extends EntityAIBase {
    private final EntityAnimal entity;
    private EntityItem targetItem;
    private int timeoutCounter;
    private double findRadius = 5.0;
    private double eatRadius = 2.0;

    public EntityAISearchFood(EntityAnimal creature) {
        this.entity = creature;
    }

    public boolean func_75250_a() {
        if (this.entity.func_70874_b() < 1 && !this.entity.func_70880_s()) {
            List entityItems;
            if (this.entity instanceof EntityWolf && !((EntityWolf)this.entity).func_70909_n()) {
                return false;
            }
            BlockPos entityPos = this.entity.func_180425_c();
            if (this.targetItem == null && !(entityItems = this.entity.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB(entityPos, entityPos.func_177982_a(1, 1, 1)).func_186662_g(this.findRadius))).isEmpty()) {
                for (EntityItem item : entityItems) {
                    if (!this.entity.func_70877_b(item.func_92059_d()) && !EasyBreeding.isOtherValidFood(item.func_92059_d(), (EntityLivingBase)this.entity)) continue;
                    this.targetItem = item;
                    break;
                }
            }
            if (this.targetItem != null) {
                BlockPos targetPos = this.targetItem.func_180425_c();
                if (entityPos.func_185332_f(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p()) <= this.eatRadius && this.targetItem.func_92059_d().func_190916_E() > 0) {
                    this.processItemEating();
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void func_75249_e() {
        if (this.entity.func_70874_b() < 1 && !this.entity.func_70880_s()) {
            if (this.entity instanceof EntityWolf && ((EntityWolf)this.entity).func_70906_o()) {
                return;
            }
            this.entity.func_70661_as().func_75492_a(this.targetItem.field_70165_t, this.targetItem.field_70163_u, this.targetItem.field_70161_v, 1.0);
        }
    }

    public boolean func_75253_b() {
        if (this.targetItem.field_70128_L || this.targetItem.func_92059_d().func_190916_E() < 1) {
            BlockPos entityPos = this.entity.func_180425_c();
            List entityItems = this.entity.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB(entityPos, entityPos.func_177982_a(1, 1, 1)).func_186662_g(this.findRadius));
            if (!entityItems.isEmpty()) {
                for (EntityItem item : entityItems) {
                    if (!this.entity.func_70877_b(item.func_92059_d())) continue;
                    this.targetItem = item;
                    break;
                }
            }
        }
        if (this.targetItem == null || this.targetItem.field_70128_L) {
            return false;
        }
        if (this.entity.func_70874_b() < 1 && !this.entity.func_70880_s()) {
            double sqDistToPos;
            if (this.entity instanceof EntityWolf && ((EntityWolf)this.entity).func_70906_o()) {
                return false;
            }
            if (this.timeoutCounter > 1200) {
                return false;
            }
            if (!this.entity.func_70661_as().func_75500_f() && (sqDistToPos = this.entity.func_70092_e(this.targetItem.field_70165_t, this.targetItem.field_70163_u, this.targetItem.field_70161_v)) > this.eatRadius) {
                return true;
            }
        }
        return false;
    }

    public void func_75246_d() {
        if (this.entity.func_70092_e(this.targetItem.field_70165_t, this.targetItem.field_70163_u, this.targetItem.field_70161_v) <= this.eatRadius && this.targetItem.func_92059_d().func_190916_E() > 0) {
            this.processItemEating();
        } else {
            ++this.timeoutCounter;
            if (this.timeoutCounter % 40 == 0) {
                this.entity.func_70661_as().func_75492_a(this.targetItem.field_70165_t, this.targetItem.field_70163_u, this.targetItem.field_70161_v, 1.0);
            }
        }
    }

    private void processItemEating() {
        if (!this.entity.func_130014_f_().field_72995_K) {
            ItemStack foodStack = this.targetItem.func_92059_d();
            boolean eaten = false;
            if (this.entity.func_70877_b(foodStack)) {
                if (this.entity.func_70874_b() == 0 && !this.entity.func_70880_s()) {
                    eaten = true;
                    this.entity.func_146082_f(null);
                } else if (this.entity.func_70631_g_()) {
                    eaten = true;
                    this.entity.func_175501_a((int)((float)(-this.entity.func_70874_b() / 20) * 0.1f), true);
                }
            }
            if (EasyBreeding.eatFood(foodStack, (EntityLivingBase)this.entity)) {
                eaten = true;
            }
            if (eaten) {
                foodStack.func_190918_g(1);
            }
        }
    }
}

