/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity.ai;

import betterwithmods.module.hardcore.creatures.chicken.EggLayer;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class AIFoodEggLayer
extends EntityAIBase {
    private final EntityAnimal entity;
    private final EggLayer layer;
    private EntityItem targetItem;
    private int timeoutCounter;

    public AIFoodEggLayer(EntityAnimal creature) {
        this.entity = creature;
        this.layer = (EggLayer)creature.getCapability(EggLayer.EGG_LAYER_CAP, EnumFacing.DOWN);
    }

    public boolean func_75250_a() {
        if (this.entity.func_70874_b() < 1 && !this.layer.isFeed()) {
            List entityItems;
            BlockPos entityPos = this.entity.func_180425_c();
            if (this.targetItem == null && !(entityItems = this.entity.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB(entityPos, entityPos.func_177982_a(1, 1, 1)).func_72321_a(5.0, 5.0, 5.0))).isEmpty()) {
                for (EntityItem item : entityItems) {
                    if (!this.layer.isBreedingItem(item.func_92059_d())) continue;
                    this.targetItem = item;
                    break;
                }
            }
            if (this.targetItem != null) {
                BlockPos targetPos = this.targetItem.func_180425_c();
                if (entityPos.func_185332_f(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p()) <= 2.0 && this.targetItem.func_92059_d().func_190916_E() > 0) {
                    this.processItemEating();
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void func_75249_e() {
        if (this.entity.func_70874_b() < 1 && !this.entity.func_70880_s()) {
            if (this.entity instanceof EntityWolf && ((EntityWolf)this.entity).func_70906_o()) {
                return;
            }
            this.entity.func_70661_as().func_75492_a(this.targetItem.field_70165_t, this.targetItem.field_70163_u, this.targetItem.field_70161_v, 1.0);
        }
    }

    public boolean func_75253_b() {
        if (this.targetItem.field_70128_L || this.targetItem.func_92059_d().func_190916_E() < 1) {
            BlockPos entityPos = this.entity.func_180425_c();
            List entityItems = this.entity.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB(entityPos, entityPos.func_177982_a(1, 1, 1)).func_72321_a(5.0, 5.0, 5.0));
            if (!entityItems.isEmpty()) {
                for (EntityItem item : entityItems) {
                    if (!this.layer.isBreedingItem(item.func_92059_d())) continue;
                    this.targetItem = item;
                    break;
                }
            }
        }
        if (this.targetItem == null || this.targetItem.field_70128_L) {
            return false;
        }
        if (this.entity.func_70874_b() < 1 && !this.layer.isFeed()) {
            double sqDistToPos;
            if (this.timeoutCounter > 1200) {
                return false;
            }
            if (!this.entity.func_70661_as().func_75500_f() && (sqDistToPos = this.entity.func_70092_e(this.targetItem.field_70165_t, this.targetItem.field_70163_u, this.targetItem.field_70161_v)) > 2.0) {
                return true;
            }
        }
        return false;
    }

    public void func_75246_d() {
        if (this.entity.func_70092_e(this.targetItem.field_70165_t, this.targetItem.field_70163_u, this.targetItem.field_70161_v) <= 2.0 && this.targetItem.func_92059_d().func_190916_E() > 0) {
            this.processItemEating();
        } else {
            ++this.timeoutCounter;
            if (this.timeoutCounter % 40 == 0) {
                this.entity.func_70661_as().func_75492_a(this.targetItem.field_70165_t, this.targetItem.field_70163_u, this.targetItem.field_70161_v, 1.0);
            }
        }
    }

    private void processItemEating() {
        if (!this.entity.func_130014_f_().field_72995_K) {
            ItemStack foodStack = this.targetItem.func_92059_d().func_77979_a(1);
            boolean bred = false;
            if (this.layer.isBreedingItem(foodStack) && this.entity.func_70874_b() == 0 && !this.layer.isFeed()) {
                bred = true;
                this.layer.feed((EntityLiving)this.entity, foodStack);
            }
            if (!bred) {
                this.targetItem.func_92059_d().func_190917_f(1);
            } else if (this.targetItem.func_92059_d().func_190916_E() < 1) {
                this.targetItem.func_70106_y();
            }
        }
    }
}

