/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity;

import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EntityMiningCharge
extends Entity {
    private static final DataParameter<Integer> FUSE = EntityDataManager.func_187226_a(EntityMiningCharge.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FACING = EntityDataManager.func_187226_a(EntityMiningCharge.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityLivingBase igniter;
    private int fuse = 80;
    private EnumFacing facing;
    private HashMap<Block, IBlockState> dropMap = new HashMap<Block, IBlockState>(){
        {
            this.put(Blocks.field_150347_e, Blocks.field_150351_n.func_176223_P());
            this.put(Blocks.field_150351_n, Blocks.field_150354_m.func_176223_P());
        }
    };

    public EntityMiningCharge(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.98f);
    }

    public EntityMiningCharge(World worldIn, double x, double y, double z, EntityLivingBase igniter, EnumFacing facing) {
        this(worldIn);
        this.setFacing(facing);
        this.func_70107_b(x, y, z);
        this.setFuse(80);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.igniter = igniter;
        this.func_189654_d(facing != EnumFacing.UP);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FUSE, (Object)80);
        this.field_70180_af.func_187214_a(FACING, (Object)EnumFacing.NORTH.func_176745_a());
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        --this.fuse;
        if (this.fuse <= 0) {
            this.func_70106_y();
            if (!this.func_130014_f_().field_72995_K) {
                this.explode();
            }
        } else {
            this.func_70072_I();
            this.func_130014_f_().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void explode() {
        this.func_130014_f_().func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.func_130014_f_().field_73012_v.nextFloat() - this.func_130014_f_().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        this.func_130014_f_().func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
        BlockPos pos = this.func_180425_c();
        EnumFacing facing = this.facing.func_176734_d();
        for (int k = 0; k <= 3; ++k) {
            int dir;
            int n = dir = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 1 : -1;
            if (k < 3) {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
                            this.explodeBlock(this.func_130014_f_(), pos.func_177982_a(i, dir * k, j));
                            continue;
                        }
                        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                            this.explodeBlock(this.func_130014_f_(), pos.func_177982_a(i, j, dir * k));
                            continue;
                        }
                        if (facing != EnumFacing.EAST && facing != EnumFacing.WEST) continue;
                        this.explodeBlock(this.func_130014_f_(), pos.func_177982_a(dir * k, i, j));
                    }
                }
                continue;
            }
            if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
                this.explodeBlock(this.func_130014_f_(), pos.func_177982_a(0, dir * k, 0));
                continue;
            }
            if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                this.explodeBlock(this.func_130014_f_(), pos.func_177982_a(0, 0, dir * k));
                continue;
            }
            if (facing != EnumFacing.EAST && facing != EnumFacing.WEST) continue;
            this.explodeBlock(this.func_130014_f_(), pos.func_177982_a(dir * k, 0, 0));
        }
        List entities = this.func_130014_f_().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos).func_72321_a(5.0, 5.0, 5.0));
        entities.forEach(entity -> entity.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)this.igniter), 45.0f));
    }

    private void explodeBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        float resistance = state.func_177230_c().getExplosionResistance(world, pos, null, null);
        if (resistance < 100.0f) {
            Explosion explosion = new Explosion(world, (Entity)this.igniter, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, false, false);
            if (state.func_177230_c().func_149659_a(explosion)) {
                if (this.dropMap.containsKey(state.func_177230_c())) {
                    IBlockState drop = this.dropMap.get(state.func_177230_c());
                    drop.func_177230_c().func_176226_b(world, pos, drop, 0);
                } else {
                    state.func_177230_c().func_176226_b(world, pos, state, 0);
                }
            }
            state.func_177230_c().onBlockExploded(world, pos, explosion);
            world.func_175698_g(pos);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("Fuse", (short)this.getFuse());
        compound.func_74774_a("Facing", (byte)this.getFacing().func_176745_a());
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setFuse(compound.func_74765_d("Fuse"));
        this.setFacing(compound.func_74771_c("Facing"));
    }

    public EntityLivingBase getTntPlacedBy() {
        return this.igniter;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (FUSE.equals(key)) {
            this.fuse = this.getFuseDM();
        }
        if (FACING.equals(key)) {
            this.facing = EnumFacing.func_82600_a((int)this.getFacingDM());
        }
    }

    public void setFacing(EnumFacing facing) {
        this.field_70180_af.func_187227_b(FACING, (Object)facing.func_176745_a());
        this.facing = facing;
    }

    public int getFuseDM() {
        return (Integer)this.field_70180_af.func_187225_a(FUSE);
    }

    public int getFacingDM() {
        return (Integer)this.field_70180_af.func_187225_a(FACING);
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(int facing) {
        this.setFacing(EnumFacing.func_82600_a((int)facing));
    }

    public int getFuse() {
        return this.fuse;
    }

    public void setFuse(int fuseIn) {
        this.field_70180_af.func_187227_b(FUSE, (Object)fuseIn);
        this.fuse = fuseIn;
    }
}

