/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.ICrankable;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.blocks.mechanical.BlockCookingPot;
import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.util.DirUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityDragonVessel
extends TileBasic
implements ITickable,
IMechanicalPower,
ICrankable {
    private final int MAX_EXPERIENCE = 1395;
    private int experience;
    private int maxDist = 5;
    private EnumFacing facing = EnumFacing.UP;
    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    public static final String BWM_PULLER_TAG = "BWMpuller";

    private int addExperience(int xp) {
        if (this.experience >= 1395) {
            return xp;
        }
        if (this.experience < 1395 - xp) {
            this.experience += xp;
            return 0;
        }
        if (this.experience >= 1395 - xp) {
            int newXp = xp - (1395 - this.experience);
            this.experience += newXp;
            return xp - newXp;
        }
        return xp;
    }

    private void hooverXP(EntityXPOrb entity) {
        if (!this.field_145850_b.field_72995_K && !entity.field_70128_L) {
            int xpValue = entity.func_70526_d();
            int xpDrained = MathHelper.func_76125_a((int)(1395 - this.experience), (int)0, (int)xpValue);
            this.addExperience(xpValue);
            this.func_70296_d();
            if ((xpValue -= xpDrained) > 0) {
                entity.field_70530_e = xpValue;
                TileEntityDragonVessel.release((Entity)entity);
            } else {
                entity.func_70106_y();
            }
        }
    }

    public void func_73660_a() {
        if (this.getBlockWorld().field_72995_K) {
            return;
        }
        if (this.getBlockWorld().func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockCookingPot) {
            IBlockState state = this.getBlockWorld().func_180495_p(this.field_174879_c);
            if (!this.isPowered()) {
                this.facing = EnumFacing.UP;
                AxisAlignedBB box = new AxisAlignedBB(this.field_174879_c).func_186662_g((double)this.maxDist);
                List xp = this.field_145850_b.func_72872_a(EntityXPOrb.class, box);
                for (EntityXPOrb entity : xp) {
                    boolean silent;
                    double zDist;
                    double yDist;
                    double xDist = (double)this.func_174877_v().func_177958_n() + 0.5 - entity.field_70165_t;
                    double totalDistance = Math.sqrt(xDist * xDist + (yDist = (double)this.func_174877_v().func_177956_o() + 0.5 - entity.field_70163_u) * yDist + (zDist = (double)this.func_174877_v().func_177952_p() + 0.5 - entity.field_70161_v) * zDist);
                    if (totalDistance < 1.5) {
                        this.hooverXP(entity);
                        continue;
                    }
                    if (!TileEntityDragonVessel.shouldAttract(this.func_174877_v(), (Entity)entity)) continue;
                    double d = 1.0 - Math.max(0.1, totalDistance) / (double)this.maxDist;
                    double speed = 0.01 + d * 0.02;
                    entity.field_70159_w += xDist / totalDistance * speed;
                    entity.field_70179_y += zDist / totalDistance * speed;
                    entity.field_70181_x += yDist / totalDistance * speed;
                    if (yDist > 0.5) {
                        entity.field_70181_x = 0.12;
                    }
                    entity.func_174810_b(!(silent = entity.func_174814_R()));
                    entity.func_174810_b(silent);
                }
            } else {
                this.facing = this.getPoweredSide();
                this.ejectExperience(DirUtils.rotateFacingAroundY(this.facing, false));
            }
            if (this.facing != state.func_177229_b((IProperty)DirUtils.TILTING)) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)DirUtils.TILTING, (Comparable)this.facing));
            }
        }
    }

    private void ejectExperience(EnumFacing facing) {
        if (this.experience > 0) {
            boolean ejectIntoWorld;
            BlockPos target = this.field_174879_c.func_177972_a(facing);
            IBlockState targetState = this.getBlockWorld().func_180495_p(target);
            boolean bl = ejectIntoWorld = this.getBlockWorld().func_175623_d(target) || targetState.func_177230_c().func_176200_f((IBlockAccess)this.getBlockWorld(), target) || !targetState.func_185904_a().func_76220_a() || targetState.func_185900_c((IBlockAccess)this.getBlockWorld(), (BlockPos)target).field_72337_e < 0.5;
            if (ejectIntoWorld) {
                BlockPos vec = new BlockPos(0, 0, 0).func_177972_a(facing);
                int xp = EntityXPOrb.func_70527_a((int)this.experience);
                this.experience -= xp;
                this.func_70296_d();
                EntityXPOrb orb = new EntityXPOrb(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f) - (double)vec.func_177958_n() / 4.0, (double)this.field_174879_c.func_177956_o() + 0.25, (double)this.field_174879_c.func_177952_p() + 0.5 - (double)vec.func_177952_p() / 4.0, xp);
                orb.field_70159_w = 0.0;
                orb.field_70181_x = 0.0;
                orb.field_70179_y = 0.0;
                this.field_145850_b.func_72838_d((Entity)orb);
            }
        }
    }

    public static boolean shouldAttract(@Nullable BlockPos pullerPos, @Nullable Entity entity) {
        if (entity == null || entity.field_70128_L) {
            return false;
        }
        if (entity instanceof IProjectile && entity.field_70181_x > 0.01) {
            return false;
        }
        NBTTagCompound data = entity.getEntityData();
        if (TileEntityDragonVessel.isReservedByOthers(data)) {
            return false;
        }
        if (!TileEntityDragonVessel.isReservedByBWM(data)) {
            if (pullerPos != null) {
                data.func_74772_a(BWM_PULLER_TAG, pullerPos.func_177986_g());
            }
            return true;
        }
        if (pullerPos == null) {
            return false;
        }
        long posL = data.func_74763_f(BWM_PULLER_TAG);
        if (posL == pullerPos.func_177986_g()) {
            return true;
        }
        BlockPos curOwner = BlockPos.func_177969_a((long)posL);
        double distToCur = curOwner.func_177957_d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        double distToMe = pullerPos.func_177957_d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (distToMe + 1.0 < distToCur) {
            data.func_74772_a(BWM_PULLER_TAG, pullerPos.func_177986_g());
            return true;
        }
        return false;
    }

    public static void release(@Nullable Entity entity) {
        if (entity != null && !entity.field_70128_L) {
            NBTTagCompound data = entity.getEntityData();
            data.func_82580_o(BWM_PULLER_TAG);
        }
    }

    public static boolean isReserved(Entity entity) {
        return TileEntityDragonVessel.isReservedByBWM(entity.getEntityData()) || TileEntityDragonVessel.isReservedByOthers(entity.getEntityData());
    }

    public static boolean isReservedByBWM(NBTTagCompound data) {
        return data.func_74764_b(BWM_PULLER_TAG);
    }

    public static boolean isReservedByOthers(NBTTagCompound data) {
        return data.func_74764_b(PREVENT_REMOTE_MOVEMENT);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.facing = tag.func_74764_b("facing") ? EnumFacing.func_82600_a((int)tag.func_74762_e("facing")) : EnumFacing.UP;
        this.experience = tag.func_74764_b("Experience") ? tag.func_74762_e("Experience") : 0;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        t.func_74768_a("facing", this.facing.func_176745_a());
        t.func_74768_a("Experience", this.experience);
        return t;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityMechanicalPower.MECHANICAL_POWER || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    private boolean isInputtingPower(EnumFacing facing) {
        return this.getMechanicalInput(facing) > 0;
    }

    private EnumFacing getPoweredSide() {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!this.isInputtingPower(facing)) continue;
            return facing;
        }
        return null;
    }

    private boolean isPowered() {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!this.isInputtingPower(facing)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return 0;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        return BWMAPI.IMPLEMENTATION.getPowerOutput(this.field_145850_b, this.field_174879_c.func_177972_a(facing), facing.func_176734_d());
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    @Override
    public Block getBlock() {
        return this.func_145838_q();
    }
}

