/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.module.hardcore.beacons.CapabilityBeacon;
import betterwithmods.module.hardcore.beacons.HCBeacons;
import betterwithmods.module.hardcore.beacons.IBeaconEffect;
import betterwithmods.module.hardcore.beacons.SpawnBeaconEffect;
import betterwithmods.util.ColorUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityBeacon
extends net.minecraft.tileentity.TileEntityBeacon
implements ITickable {
    private int level;
    private int prevLevel;
    private IBlockState type = Blocks.field_150350_a.func_176223_P();
    private IBeaconEffect effect;
    private IBeaconEffect prevEffect;
    private int tick;
    private List<BeamSegment> segments = Lists.newArrayList();
    @SideOnly(value=Side.CLIENT)
    private long beamRenderCounter;
    @SideOnly(value=Side.CLIENT)
    private float beamRenderScale;

    public TileEntityBeacon() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean canSeeSky() {
        if (this.field_145850_b.field_73011_w.func_76569_d()) {
            return this.field_145850_b.func_175710_j(this.field_174879_c);
        }
        if (this.field_145850_b.field_73011_w.func_177495_o()) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.func_174877_v().func_177984_a());
            while (pos.func_177956_o() < 128) {
                IBlockState state = this.field_145850_b.func_180495_p((BlockPos)pos);
                if (state.func_177230_c() == Blocks.field_150357_h) {
                    return true;
                }
                if (state.func_177230_c().getLightOpacity(state, (IBlockAccess)this.field_145850_b, (BlockPos)pos) > 0) {
                    return false;
                }
                pos.func_185336_p(pos.func_177956_o() + 1);
            }
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (this.tick <= 0) {
            if (!this.canSeeSky()) {
                if (this.level != 0) {
                    this.level = 0;
                    this.prevLevel = 0;
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187849_gA, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return;
            }
            Pair<Integer, IBlockState> current = this.calcLevel();
            this.level = (Integer)current.getKey();
            this.type = (IBlockState)current.getValue();
            if (this.level > 0) {
                this.effect = HCBeacons.getBeaconEffect(this.type);
                if (this.level != this.prevLevel) {
                    CapabilityBeacon storage = (CapabilityBeacon)this.field_145850_b.getCapability(CapabilityBeacon.BEACON_CAPABILITY, EnumFacing.UP);
                    if (storage != null) {
                        storage.addBeacon(this.field_174879_c, this.level);
                    }
                    this.field_145850_b.func_175669_a(1023, this.func_174877_v(), 0);
                    if (this.effect != null) {
                        this.effect.breakBlock(this.field_145850_b, this.field_174879_c, this.prevLevel);
                    }
                    this.field_145850_b.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, -4, 1)).func_72314_b(10.0, 5.0, 10.0)).forEach(player -> CriteriaTriggers.field_192131_k.func_192180_a(player, (net.minecraft.tileentity.TileEntityBeacon)this));
                }
                if (this.effect != null) {
                    this.effect.effect(this.field_145850_b, this.field_174879_c, this.level);
                    this.calcSegments();
                }
                this.prevEffect = this.effect;
            } else {
                this.segments.clear();
                this.effect = null;
                CapabilityBeacon storage = (CapabilityBeacon)this.field_145850_b.getCapability(CapabilityBeacon.BEACON_CAPABILITY, EnumFacing.UP);
                if (storage != null) {
                    storage.removeBeacon(this.field_174879_c);
                }
            }
            if (this.prevEffect != null && this.effect != this.prevEffect) {
                this.prevEffect.breakBlock(this.field_145850_b, this.field_174879_c, this.prevLevel);
            }
            if (this.level != this.prevLevel) {
                this.prevLevel = this.level;
            }
            this.tick = this.effect != null ? this.effect.getTickSpeed() : 120;
        }
        --this.tick;
    }

    @SideOnly(value=Side.CLIENT)
    public float getBeamScale() {
        int i = (int)(this.field_145850_b.func_82737_E() - this.beamRenderCounter);
        this.beamRenderCounter = this.field_145850_b.func_82737_E();
        if (i > 1) {
            this.beamRenderScale -= (float)i / 40.0f;
            if (this.beamRenderScale < 0.0f) {
                this.beamRenderScale = 0.0f;
            }
        }
        this.beamRenderScale += 0.025f;
        if (this.beamRenderScale > 1.0f) {
            this.beamRenderScale = 1.0f;
        }
        return this.beamRenderScale;
    }

    private void calcSegments() {
        this.segments.clear();
        BeamSegment segment = new BeamSegment(ColorUtils.getColorFromBlock(this.field_145850_b, this.func_174877_v().func_177984_a(), this.func_174877_v()));
        this.segments.add(segment);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.func_174877_v().func_177984_a());
        while (pos.func_177956_o() < 256) {
            float[] color = ColorUtils.getColorFromBlock(this.field_145850_b, (BlockPos)pos, this.func_174877_v());
            if (!Arrays.equals(color, new float[]{1.0f, 1.0f, 1.0f})) {
                if (Arrays.equals(color = ColorUtils.average(color, segment.func_177263_b()), segment.func_177263_b())) {
                    segment.func_177262_a();
                } else {
                    segment = new BeamSegment(color);
                    this.segments.add(segment);
                }
            } else {
                segment.func_177262_a();
            }
            pos.func_189536_c(EnumFacing.UP);
        }
    }

    public List<BeamSegment> getSegments() {
        return this.segments;
    }

    private boolean isSameBlock(IBlockState state, int x, int y, int z) {
        BlockPos pos = this.func_174877_v().func_177982_a(x, y, z);
        return state == this.field_145850_b.func_180495_p(pos);
    }

    private boolean isValidBlock(IBlockState state) {
        return HCBeacons.BEACON_EFFECTS.containsKey(state) || state.func_177230_c().isBeaconBase((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177977_b(), this.field_174879_c);
    }

    public Pair<Integer, IBlockState> calcLevel() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        if (this.isValidBlock(state)) {
            int r;
            for (r = 1; r <= 4; ++r) {
                for (int x = -r; x <= r; ++x) {
                    for (int z = -r; z <= r; ++z) {
                        if (this.isSameBlock(state, x, -r, z)) continue;
                        return Pair.of((Object)(r - 1), (Object)state);
                    }
                }
            }
            return Pair.of((Object)(r - 1), (Object)state);
        }
        return Pair.of((Object)0, (Object)Blocks.field_150350_a.func_176223_P());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("level", this.level);
        compound.func_74768_a("prevLevel", this.prevLevel);
        compound.func_74768_a("tick", this.tick);
        NBTTagCompound tag = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)tag, (IBlockState)this.type);
        compound.func_74782_a("type", (NBTBase)tag);
        if (SpawnBeaconEffect.SPAWN_LIST.containsKey(this.func_174877_v())) {
            NBTTagList list = new NBTTagList();
            for (SpawnBeaconEffect.BindingPoint point : SpawnBeaconEffect.SPAWN_LIST.get(this.func_174877_v())) {
                list.func_74742_a((NBTBase)point.serializeNBT());
            }
            compound.func_74782_a("spawns", (NBTBase)list);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.level = compound.func_74762_e("level");
        this.prevLevel = compound.func_74762_e("prevLevel");
        this.tick = compound.func_74762_e("tick");
        NBTTagCompound type = (NBTTagCompound)compound.func_74781_a("type");
        this.type = NBTUtil.func_190008_d((NBTTagCompound)type);
        if (compound.func_74764_b("spawns")) {
            NBTTagList list = compound.func_150295_c("spawns", 10);
            HashSet points = Sets.newHashSet();
            for (NBTTagCompound tag : list) {
                points.add(new SpawnBeaconEffect.BindingPoint(tag));
            }
            SpawnBeaconEffect.SPAWN_LIST.put(this.func_174877_v(), points);
        }
        super.func_145839_a(compound);
    }

    public boolean processInteraction(World world, EntityPlayer player, ItemStack stack) {
        Block block;
        IBlockState state;
        if (player.func_184812_l_() && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock && this.isValidBlock(state = (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()).func_176203_a(stack.func_77960_j()))) {
            for (int r = 1; r <= stack.func_190916_E(); ++r) {
                for (int x = -r; x <= r; ++x) {
                    for (int z = -r; z <= r; ++z) {
                        this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(x, -r, z), state);
                    }
                }
            }
        }
        if (!world.field_72995_K && this.effect != null) {
            boolean interacted = this.effect.processInteractions(world, this.func_174877_v(), this.func_191979_s() - 1, player, stack);
            if (interacted) {
                this.field_145850_b.func_175669_a(1023, this.func_174877_v(), 0);
            }
            return interacted;
        }
        return false;
    }

    public int func_191979_s() {
        return this.level;
    }

    public boolean isEnabled() {
        return this.level > 0;
    }

    public void onRemoved() {
        this.breakBlock();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        SpawnBeaconEffect.removeAll(this.func_174877_v());
        CapabilityBeacon storage = (CapabilityBeacon)this.field_145850_b.getCapability(CapabilityBeacon.BEACON_CAPABILITY, EnumFacing.UP);
        if (storage != null) {
            storage.removeBeacon(this.field_174879_c);
        }
    }

    @SubscribeEvent
    public void findSpawn(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        if (SpawnBeaconEffect.shouldSpawnHere(this.func_174877_v(), (EntityPlayer)player, this.field_145850_b)) {
            player.func_180473_a(this.func_174877_v().func_177984_a(), true);
        } else {
            player.func_180473_a(this.field_145850_b.func_175694_M(), false);
        }
    }

    public void breakBlock() {
        if (this.effect != null) {
            this.effect.breakBlock(this.field_145850_b, this.field_174879_c, this.level);
        }
    }

    public class BeamSegment
    extends TileEntityBeacon.BeamSegment {
        public BeamSegment(float[] colorsIn) {
            super(colorsIn);
        }

        protected void func_177262_a() {
            super.func_177262_a();
        }
    }
}

