/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.BlockAxle;
import betterwithmods.common.blocks.mechanical.BlockWindmill;
import betterwithmods.common.blocks.mechanical.tile.TileEntityBaseWindmill;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWindmillVertical
extends TileEntityBaseWindmill {
    public TileEntityWindmillVertical() {
        this.bladeMeta = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    }

    public boolean isSlaveValid(int offset) {
        int airCounter = 0;
        for (int x = -this.getRadius(); x <= this.getRadius(); ++x) {
            for (int z = -this.getRadius(); z <= this.getRadius(); ++z) {
                BlockPos offPos = this.field_174879_c.func_177982_a(x, offset, z);
                double s = Math.sqrt(x * x + z * z);
                if (s > 4.5) continue;
                if (x == 0 && z == 0) {
                    IBlockState state = this.getBlockWorld().func_180495_p(offPos);
                    if (state.func_177230_c() instanceof BlockAxle) continue;
                    return false;
                }
                if (this.getBlockWorld().func_175623_d(offPos)) {
                    ++airCounter;
                    continue;
                }
                return false;
            }
        }
        return airCounter > 25;
    }

    @Override
    public void verifyIntegrity() {
        boolean valid = false;
        if (this.getBlockWorld().func_180495_p(this.field_174879_c).func_177230_c() == BWMBlocks.WINDMILL) {
            for (int i = -3; i <= 3; ++i) {
                if (i == 0) continue;
                if (this.isSlaveValid(i)) {
                    valid = true;
                    continue;
                }
                valid = false;
                break;
            }
        }
        this.isValid = valid && !this.isEnd();
    }

    @Override
    public int getRadius() {
        return 4;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager mgr, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
        IBlockState state = this.getBlockWorld().func_180495_p(this.field_174879_c);
        this.getBlockWorld().func_184138_a(this.field_174879_c, state, state, 3);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        IBlockState state = this.getBlockWorld().func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockWindmill) {
            return new AxisAlignedBB(this.field_174879_c).func_72314_b(4.0, 3.0, 4.0);
        }
        return super.getRenderBoundingBox();
    }
}

