/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.tile.IMechSubtype;
import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.common.registry.TurntableRotationManager;
import betterwithmods.common.registry.block.recipe.TurntableRecipe;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityTurntable
extends TileBasic
implements IMechSubtype,
ITickable,
IMechanicalPower {
    private static final int height = 3;
    private static final int[] ticksToRotate = new int[]{10, 20, 40, 80};
    public byte timerPos = 0;
    private int potteryRotation = 0;
    private double[] offsets = new double[]{0.25, 0.375, 0.5, 0.625};
    private boolean asynchronous = false;
    private int rotationTime = 0;
    private int power;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("SwitchSetting")) {
            this.timerPos = tag.func_74771_c("SwitchSetting");
            if (this.timerPos > 3) {
                this.timerPos = (byte)3;
            }
        }
        if (tag.func_74764_b("PotteryRotation")) {
            this.potteryRotation = tag.func_74762_e("PotteryRotation");
        }
        if (tag.func_74764_b("Asynchronous")) {
            this.asynchronous = tag.func_74767_n("Asynchronous");
        }
        if (tag.func_74764_b("RotationTime")) {
            this.rotationTime = tag.func_74762_e("RotationTime");
        }
        this.power = tag.func_74762_e("power");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("PotteryRotation", this.potteryRotation);
        tag.func_74774_a("SwitchSetting", this.timerPos);
        tag.func_74757_a("Asynchronous", this.asynchronous);
        if (this.asynchronous || this.rotationTime != 0) {
            tag.func_74768_a("RotationTime", this.rotationTime);
        }
        tag.func_74768_a("power", this.power);
        return tag;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        if (!this.getBlockWorld().field_72995_K) {
            this.power = this.calculateInput();
            if (this.power > 0) {
                if (!this.asynchronous && this.getBlockWorld().func_82737_E() % (long)ticksToRotate[this.timerPos] == 0L) {
                    this.getBlockWorld().func_184133_a(null, this.field_174879_c, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.05f, 1.0f);
                    this.rotateTurntable();
                } else if (this.asynchronous) {
                    ++this.rotationTime;
                    if (this.rotationTime >= ticksToRotate[this.timerPos]) {
                        this.rotationTime = 0;
                        this.getBlockWorld().func_184133_a(null, this.field_174879_c, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.05f, 1.0f);
                        this.rotateTurntable();
                    }
                }
            }
        }
    }

    public boolean processRightClick(EntityPlayer player) {
        if (!player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            if (player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == Items.field_151113_aN) {
                this.toggleAsynchronous(player);
                return true;
            }
        } else if (player.func_184614_ca().func_190926_b()) {
            this.advanceTimerPos();
            this.getBlockWorld().func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.getBlockWorld()), 5);
            this.getBlockWorld().func_184133_a(null, this.field_174879_c, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
            return true;
        }
        return false;
    }

    public void toggleAsynchronous(EntityPlayer player) {
        if (!this.getBlockWorld().func_82736_K().func_82766_b("doDaylightCycle")) {
            if (!this.asynchronous) {
                this.asynchronous = true;
            } else if (player != null) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("message.bwm:async.unavailable", new Object[0]), false);
            }
        } else {
            boolean async;
            boolean isSneaking = player.func_70093_af();
            String isOn = "enabled";
            boolean bl = async = !this.asynchronous;
            if (!async && !isSneaking || async && isSneaking) {
                isOn = "disabled";
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("message.bwm:async." + isOn, new Object[0]), false);
            if (!isSneaking) {
                this.getBlockWorld().func_184133_a(null, this.field_174879_c, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.05f, 1.0f);
                this.asynchronous = async;
            }
        }
    }

    public void rotateTurntable() {
        Rotation rotation = BWMAPI.IMPLEMENTATION.isRedstonePowered(this.field_145850_b, this.field_174879_c) ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.func_174877_v());
        for (int i = 1; i < 3; ++i) {
            pos.func_185336_p(pos.func_177956_o() + 1);
            TurntableRotationManager.IRotation handler = this.rotateBlock((BlockPos)pos, rotation);
            if (handler == null) break;
            if (handler.canTransmitHorizontally(this.field_145850_b, (BlockPos)pos)) {
                TurntableRotationManager.rotateAttachments(this.field_145850_b, (BlockPos)pos, rotation);
            }
            if (!handler.canTransmitVertically(this.field_145850_b, (BlockPos)pos)) break;
        }
        this.getBlockWorld().func_190524_a((BlockPos)pos, BWMBlocks.SINGLE_MACHINES, (BlockPos)pos);
    }

    public byte getTimerPos() {
        return this.timerPos;
    }

    public double getOffset() {
        return this.offsets[this.timerPos];
    }

    public void advanceTimerPos() {
        this.timerPos = (byte)(this.timerPos + 1);
        if (this.timerPos > 3) {
            this.timerPos = 0;
        }
        IBlockState state = this.getBlockWorld().func_180495_p(this.field_174879_c);
        this.getBlockWorld().func_184138_a(this.field_174879_c, state, state, 3);
    }

    private TurntableRotationManager.IRotation rotateBlock(BlockPos pos, Rotation rotation) {
        IBlockState input = this.getBlockWorld().func_180495_p(pos);
        this.rotateCraftable(this.field_145850_b, pos, input);
        return TurntableRotationManager.rotate(this.field_145850_b, pos, rotation);
    }

    private void spawnParticlesAndSound(IBlockState state) {
        if (state.func_185904_a() != Material.field_151579_a) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, state.func_177230_c().getSoundType(state, this.field_145850_b, this.field_174879_c, null).func_185841_e(), SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.8f);
            ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.BLOCK_DUST, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, 30, 0.0, 0.5, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)state)});
        }
    }

    private void rotateCraftable(World world, BlockPos pos, IBlockState input) {
        TurntableRecipe recipe = BWRegistry.TURNTABLE.findRecipe(world, pos, input).orElse(null);
        if (recipe != null) {
            ++this.potteryRotation;
            this.spawnParticlesAndSound(input);
            if (recipe.craftRecipe(world, pos, world.field_73012_v, input)) {
                this.potteryRotation = 0;
            }
        } else {
            this.potteryRotation = 0;
        }
    }

    @Override
    public int getSubtype() {
        return this.timerPos + 8;
    }

    @Override
    public void setSubtype(int type) {
        this.timerPos = (byte)Math.min(type, 3);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(this.field_145850_b, this.field_174879_c.func_177972_a(facing), facing.func_176734_d());
        }
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.func_174877_v();
    }

    @Override
    public Block getBlock() {
        return this.func_145838_q();
    }

    public int getPotteryRotation() {
        return this.potteryRotation;
    }
}

