/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.ICrankable;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.api.util.IProgressSource;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import betterwithmods.common.blocks.mechanical.tile.TileCrank;
import betterwithmods.common.blocks.tile.TileBasicInventory;
import betterwithmods.util.DirUtils;
import betterwithmods.util.StackEjector;
import betterwithmods.util.VectorBuilder;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityMill
extends TileBasicInventory
implements ITickable,
IMechanicalPower,
ICrankable,
IProgressSource {
    public boolean blocked;
    public int power;
    public int grindCounter = 0;
    public int grindMax;
    private int increment = 1;

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public boolean isActive() {
        return this.power > 0;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public BlockMechMachines getBlock() {
        if (this.func_145838_q() instanceof BlockMechMachines) {
            return (BlockMechMachines)this.func_145838_q();
        }
        throw new IllegalStateException("This TileEntity does not have the correct block, something is severely wrong. Report to the mod author immediately");
    }

    private boolean findIfBlocked() {
        int count = 0;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos offset = this.field_174879_c.func_177972_a(facing);
            IBlockState state = this.field_145850_b.func_180495_p(offset);
            Material material = state.func_185904_a();
            if (!this.field_145850_b.isSideSolid(offset, facing.func_176734_d()) && (material.func_76222_j() || material.func_76218_k())) continue;
            ++count;
        }
        return count > 1;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void func_73660_a() {
        if (this.getBlockWorld().field_72995_K) {
            return;
        }
        this.power = this.calculateInput();
        this.blocked = this.findIfBlocked();
        this.getBlock().setActive(this.field_145850_b, this.field_174879_c, this.isActive());
        if (this.isBlocked()) {
            return;
        }
        if (this.isActive()) {
            BWRegistry.MILLSTONE.craftRecipe(this.field_145850_b, this, this.inventory);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("blocked")) {
            this.blocked = tag.func_74767_n("blocked");
        }
        if (tag.func_74764_b("GrindCounter")) {
            this.grindCounter = tag.func_74762_e("GrindCounter");
        }
        if (tag.func_74764_b("GrindMax")) {
            this.grindMax = tag.func_74762_e("GrindMax");
        }
        if (tag.func_74764_b("increment")) {
            this.increment = tag.func_74762_e("increment");
        }
        this.power = tag.func_74762_e("power");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("GrindCounter", this.grindCounter);
        tag.func_74768_a("GrindMax", this.grindMax);
        tag.func_74768_a("power", this.power);
        tag.func_74768_a("increment", this.increment);
        tag.func_74757_a("blocked", this.blocked);
        return tag;
    }

    @Override
    public int getInventorySize() {
        return 3;
    }

    private boolean canEject(EnumFacing facing) {
        if (this.field_145850_b.func_175623_d(this.field_174879_c.func_177972_a(facing))) {
            return true;
        }
        return !this.field_145850_b.func_175665_u(this.field_174879_c.func_177972_a(facing)) && !this.field_145850_b.isSideSolid(this.field_174879_c.func_177972_a(facing), facing.func_176734_d());
    }

    private void ejectStack(ItemStack stack) {
        List<EnumFacing> validDirections = Lists.newArrayList((Object[])EnumFacing.field_176754_o).stream().filter(this::canEject).collect(Collectors.toList());
        if (validDirections.isEmpty()) {
            this.blocked = true;
            return;
        }
        VectorBuilder builder = new VectorBuilder();
        BlockPos offset = this.field_174879_c.func_177972_a(DirUtils.getRandomFacing(validDirections, this.getBlockWorld().field_73012_v));
        new StackEjector(this.field_145850_b, stack, builder.set((Vec3i)offset).rand(0.5).offset(0.25).build(), builder.setGaussian(0.05f, 0.0, 0.05f).build()).ejectStack();
    }

    public void ejectRecipe(NonNullList<ItemStack> output) {
        if (!output.isEmpty()) {
            for (ItemStack anOutput : output) {
                ItemStack stack = anOutput.func_77946_l();
                if (stack.func_190926_b()) continue;
                this.ejectStack(stack);
            }
        }
    }

    public boolean isGrinding() {
        return this.grindCounter > 0;
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        if (facing.func_176740_k().func_176720_b()) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(this.field_145850_b, this.field_174879_c.func_177972_a(facing), facing.func_176734_d());
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing)) instanceof TileCrank) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(this.field_145850_b, this.field_174879_c.func_177972_a(facing), facing.func_176734_d());
        }
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.getBlockWorld().func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public int getMax() {
        return this.grindMax;
    }

    @Override
    public int getProgress() {
        return this.grindCounter;
    }
}

