/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.block.ISoulSensitive;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IHopperFilter;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.api.util.IProgressSource;
import betterwithmods.client.model.filters.ModelWithResource;
import betterwithmods.client.model.render.RenderUtils;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import betterwithmods.common.blocks.tile.SimpleStackHandler;
import betterwithmods.common.blocks.tile.TileEntityVisibleInventory;
import betterwithmods.common.registry.HopperFilter;
import betterwithmods.common.registry.HopperInteractions;
import betterwithmods.util.InvUtils;
import betterwithmods.util.WorldUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;

public class TileEntityFilteredHopper
extends TileEntityVisibleInventory
implements IMechanicalPower,
IProgressSource {
    private final int STACK_SIZE = 8;
    public SimpleStackHandler filter;
    public IHopperFilter hopperFilter = HopperFilter.NONE;
    public int soulsRetained = 0;
    public byte power;
    private int ejectCounter = 0;
    private int ejectXPCounter = 10;
    private int experienceCount = 0;
    private int maxExperienceCount = 1000;
    private ISoulSensitive prevContainer;

    public TileEntityFilteredHopper() {
        this.occupiedSlots = 0;
        this.hasCapability = facing -> facing == EnumFacing.DOWN || facing == EnumFacing.UP;
        this.filter = new SimpleStackHandler(1, this);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("EjectCounter")) {
            this.ejectCounter = tag.func_74762_e("EjectCounter");
        }
        if (tag.func_74764_b("XPCount")) {
            this.experienceCount = tag.func_74762_e("XPCount");
        }
        if (tag.func_74764_b("Souls")) {
            this.soulsRetained = tag.func_74762_e("Souls");
        }
        this.power = tag.func_74771_c("power");
        if (tag.func_74764_b("Item")) {
            this.filter.setStackInSlot(0, new ItemStack(tag.func_74775_l("Item")));
        }
        this.validateInventory();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        t.func_74768_a("EjectCounter", this.ejectCounter);
        t.func_74768_a("XPCount", this.experienceCount);
        t.func_74768_a("Souls", this.soulsRetained);
        t.func_74774_a("power", this.power);
        if (!this.filter.getStackInSlot(0).func_190926_b()) {
            NBTTagCompound itemTag = new NBTTagCompound();
            this.filter.getStackInSlot(0).func_77955_b(itemTag);
            t.func_74782_a("Item", (NBTBase)itemTag);
        }
        return t;
    }

    public boolean isPowered() {
        return this.power > 0;
    }

    public boolean isXPFull() {
        return this.experienceCount >= this.maxExperienceCount;
    }

    public void insert(Entity entity) {
        if (!InvUtils.isFull((IItemHandler)this.inventory) && entity instanceof EntityItem) {
            EntityItem item = (EntityItem)entity;
            if (item.field_70128_L) {
                return;
            }
            if (HopperInteractions.attemptToCraft(this.hopperFilter.getName(), this.getBlockWorld(), this.getBlockPos(), item, this)) {
                this.getBlockWorld().func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.getBlockWorld().field_73012_v.nextFloat() - this.getBlockWorld().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            } else if (this.canFilterProcessItem(item.func_92059_d()) && InvUtils.insertFromWorld((IItemHandler)this.inventory, item, 0, 18, false)) {
                this.getBlockWorld().func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.getBlockWorld().field_73012_v.nextFloat() - this.getBlockWorld().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
        this.hopperFilter.onInsert(this.field_145850_b, this.field_174879_c, this, entity);
    }

    private void extract() {
        Optional<IItemHandler> inv = InvUtils.getItemHandler(this.field_145850_b, this.field_174879_c.func_177977_b(), EnumFacing.UP);
        if (this.ejectCounter > 2) {
            int slot = InvUtils.getFirstOccupiedStackInRange((IItemHandler)this.inventory, 0, 17);
            if (slot != -1) {
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (inv.isPresent()) {
                    if (InvUtils.canInsert(inv.get(), stack, 8)) {
                        ItemStack insert = InvUtils.insert(inv.get(), stack, 8, false);
                        InvUtils.consumeItemsInInventory((IItemHandler)this.inventory, stack, 8 - insert.func_190916_E(), false);
                    }
                } else if (this.canDropIntoBlock(this.field_174879_c.func_177977_b())) {
                    InvUtils.consumeItemsInInventory((IItemHandler)this.inventory, stack, 8, false);
                    InvUtils.spawnStack(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() - 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 8, stack);
                }
            }
            this.ejectCounter = 0;
        } else {
            ++this.ejectCounter;
        }
        if (this.ejectXPCounter > 2) {
            if (this.canDropIntoBlock(this.field_174879_c.func_177977_b()) && this.experienceCount > 19) {
                this.experienceCount -= 20;
                this.spawnEntityXPOrb(20);
            }
            this.ejectXPCounter = 0;
        } else {
            ++this.ejectXPCounter;
        }
    }

    private boolean canDropIntoBlock(BlockPos pos) {
        return this.field_145850_b.func_180495_p(pos).func_185904_a().func_76222_j();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            byte power = (byte)this.calculateInput();
            if (this.power != power) {
                this.power = power;
            }
            if (this.getBlock() != null) {
                this.getBlock().setActive(this.field_145850_b, this.field_174879_c, this.isActive());
            }
            if (this.isPowered()) {
                this.extract();
            }
        }
    }

    public boolean isActive() {
        return this.power > 0;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        return this.getBlockWorld().func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) <= 64.0;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (this.getBlockWorld() != null) {
            this.validateInventory();
        }
    }

    private boolean validateInventory() {
        byte slotsOccupied;
        boolean stateChanged = false;
        ItemStack filter = this.getFilterStack();
        IHopperFilter newFilter = BWRegistry.HOPPER_FILTERS.getFilter(filter);
        if (this.hopperFilter != newFilter) {
            this.hopperFilter = newFilter;
            stateChanged = true;
        }
        if ((slotsOccupied = (byte)InvUtils.getOccupiedStacks((IItemHandler)this.inventory, 0, 17)) != this.occupiedSlots) {
            this.occupiedSlots = slotsOccupied;
            stateChanged = true;
        }
        if (this.getBlockWorld() != null && stateChanged) {
            IBlockState state = this.getBlockWorld().func_180495_p(this.field_174879_c);
            this.getBlockWorld().func_184138_a(this.field_174879_c, state, state, 3);
        }
        return stateChanged;
    }

    public IHopperFilter getHopperFilter() {
        return this.hopperFilter;
    }

    private boolean canFilterProcessItem(ItemStack stack) {
        this.validateInventory();
        return this.hopperFilter.allow(stack);
    }

    private void spawnEntityXPOrb(int value) {
        double xOff = this.getBlockWorld().field_73012_v.nextDouble() * 0.1 + 0.45;
        double yOff = -0.5;
        double zOff = this.getBlockWorld().field_73012_v.nextDouble() * 0.1 + 0.45;
        EntityXPOrb orb = new EntityXPOrb(this.getBlockWorld(), (double)this.field_174879_c.func_177958_n() + xOff, (double)this.field_174879_c.func_177956_o() + yOff, (double)this.field_174879_c.func_177952_p() + zOff, value);
        orb.field_70159_w = 0.0;
        orb.field_70181_x = 0.0;
        orb.field_70179_y = 0.0;
        this.getBlockWorld().func_72838_d((Entity)orb);
    }

    @Nullable
    public ISoulSensitive getSoulContainer() {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c();
        if (block instanceof ISoulSensitive && ((ISoulSensitive)block).isSoulSensitive((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177977_b())) {
            return (ISoulSensitive)block;
        }
        return null;
    }

    public void decreaseSoulCount(int numSouls) {
        this.soulsRetained = Math.max(this.soulsRetained - numSouls, 0);
        this.func_70296_d();
    }

    public void increaseSoulCount(int numSouls) {
        this.soulsRetained += numSouls;
        ISoulSensitive container = this.getSoulContainer();
        if (container != null) {
            if (this.prevContainer != container) {
                this.soulsRetained = numSouls;
            }
            int soulsConsumed = container.processSouls(this.getBlockWorld(), this.field_174879_c.func_177977_b(), this.soulsRetained);
            if (container.consumeSouls(this.getBlockWorld(), this.field_174879_c.func_177977_b(), soulsConsumed)) {
                this.soulsRetained -= soulsConsumed;
            }
        } else if (this.soulsRetained > 7 && !this.isPowered()) {
            if (WorldUtils.spawnGhast(this.field_145850_b, this.field_174879_c)) {
                this.getBlockWorld().func_184133_a(null, this.field_174879_c, SoundEvents.field_189105_bM, SoundCategory.BLOCKS, 1.0f, this.getBlockWorld().field_73012_v.nextFloat() * 0.1f + 0.8f);
            }
            this.overpower();
        }
        this.prevContainer = container;
        this.func_70296_d();
    }

    @Override
    public int getInventorySize() {
        return 18;
    }

    @Override
    public SimpleStackHandler createItemStackHandler() {
        return new HopperHandler(this.getInventorySize(), this);
    }

    @Override
    public String getName() {
        return "inv.filtered_hopper.name";
    }

    @Override
    public int getMaxVisibleSlots() {
        return 18;
    }

    public ModelWithResource getModel() {
        return RenderUtils.getModelFromStack(this.getFilterStack());
    }

    public ItemStack getFilterStack() {
        return this.filter.getStackInSlot(0);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        if (facing.func_176740_k().func_176722_c()) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(this.field_145850_b, this.field_174879_c.func_177972_a(facing), facing.func_176734_d());
        }
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.func_174877_v();
    }

    @Override
    public BlockMechMachines getBlock() {
        if (this.func_145838_q() instanceof BlockMechMachines) {
            return (BlockMechMachines)this.func_145838_q();
        }
        return null;
    }

    @Override
    public void onBreak() {
        super.onBreak();
        InvUtils.ejectInventoryContents(this.field_145850_b, this.field_174879_c, (IItemHandler)this.filter);
    }

    public int getExperienceCount() {
        return this.experienceCount;
    }

    public void setExperienceCount(int experienceCount) {
        this.experienceCount = experienceCount;
    }

    public int getMaxExperienceCount() {
        return this.maxExperienceCount;
    }

    @Override
    public int getMax() {
        return 1;
    }

    @Override
    public int getProgress() {
        return Math.min(this.power, 1);
    }

    private class HopperHandler
    extends SimpleStackHandler {
        TileEntityFilteredHopper hopper;

        public HopperHandler(int size, TileEntityFilteredHopper hopper) {
            super(size, hopper);
            this.hopper = hopper;
        }

        @Override
        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityFilteredHopper.this.field_145850_b.func_175704_b(TileEntityFilteredHopper.this.field_174879_c, TileEntityFilteredHopper.this.field_174879_c);
            TileEntityFilteredHopper.this.getBlockWorld().func_184138_a(TileEntityFilteredHopper.this.field_174879_c, TileEntityFilteredHopper.this.field_145850_b.func_180495_p(TileEntityFilteredHopper.this.field_174879_c), TileEntityFilteredHopper.this.field_145850_b.func_180495_p(TileEntityFilteredHopper.this.field_174879_c), 2);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.hopper.canFilterProcessItem(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlotLimit(int slot) {
            return slot == 18 ? 1 : super.getSlotLimit(slot);
        }
    }
}

