/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.IMultiLocations;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.blocks.BlockLight;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockHemp
extends BlockCrops
implements IPlantable,
IMultiLocations {
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.25, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.375, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.5, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.75, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.875, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125)};
    public static double growthChance;
    public static double lampModifier;
    public static double fertileModifier;
    public static double neighborModifier;

    public BlockHemp() {
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[(Integer)state.func_177229_b((IProperty)this.func_185524_e())];
    }

    @Override
    public String[] getLocations() {
        return new String[]{"hemp_seed"};
    }

    public boolean func_185525_y(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)TOP) != false || (Integer)state.func_177229_b((IProperty)field_176488_a) > 6;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        IBlockState above = worldIn.func_180495_p(pos.func_177984_a());
        return (Boolean)state.func_177229_b((IProperty)TOP) == false && !(above.func_177230_c() instanceof BlockHemp);
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        return !(world.func_175699_k(pos) <= 12 && !world.func_175678_i(pos) && !world.func_175678_i(pos.func_177984_a()) && !this.isBelowLightBlock(world, pos) || !this.canBePlantedHere(world, pos) && !this.canPlantGrowOnBlock(world.func_180495_p(pos.func_177977_b())));
    }

    private boolean isBelowLightBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockLight || world.func_180495_p(pos.func_177981_b(2)).func_177230_c() instanceof BlockLight;
    }

    public boolean canBePlantedHere(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c().canSustainPlant(world.func_180495_p(pos.func_177977_b()), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public void func_176487_g(World worldIn, BlockPos pos, IBlockState state) {
        if (!((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue() && (Integer)state.func_177229_b((IProperty)field_176488_a) >= 7) {
            worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)));
        }
        super.func_176487_g(worldIn, pos, state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.func_176475_e(world, pos, state);
        BlockPos up = pos.func_177984_a();
        int age = (Integer)state.func_177229_b((IProperty)field_176488_a);
        boolean isTop = (Boolean)state.func_177229_b((IProperty)TOP);
        double growthChance = BlockHemp.growthChance;
        if (world.func_180495_p(pos.func_177981_b(2)).func_177230_c() instanceof BlockLight && world.func_175623_d(pos.func_177984_a()) && ((Boolean)world.func_180495_p(pos.func_177981_b(2)).func_177229_b((IProperty)BlockLight.ACTIVE)).booleanValue()) {
            growthChance /= lampModifier;
        }
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c().isFertile(world, pos.func_177977_b())) {
            growthChance /= fertileModifier;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            IBlockState check = world.func_180495_p(pos.func_177972_a(facing));
            if (check.func_177230_c() != this) continue;
            growthChance /= neighborModifier;
        }
        if (age < 7) {
            if (world.func_175671_l(up) > 12 && rand.nextInt(MathHelper.func_76128_c((double)growthChance)) == 0) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(age + 1)));
            }
        } else if (age == 7 && world.func_175623_d(up) && !isTop && world.func_175671_l(up) > 12 && rand.nextInt(MathHelper.func_76128_c((double)(growthChance * growthChance))) == 0) {
            world.func_175656_a(up, state.func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(7)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)));
        }
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, 0);
    }

    private boolean canPlantGrowOnBlock(IBlockState state) {
        Block block = state.func_177230_c();
        return block == this && (Integer)state.func_177229_b((IProperty)field_176488_a) == 7;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    protected void func_176475_e(World world, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(world, pos, state)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public int func_180651_a(IBlockState state) {
        int meta = (Integer)state.func_177229_b((IProperty)field_176488_a);
        return meta > 6 ? 2 : 0;
    }

    protected Item func_149866_i() {
        return Item.func_150898_a((Block)BWMBlocks.HEMP);
    }

    protected Item func_149865_P() {
        return BWMItems.MATERIAL;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176488_a, TOP});
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 8) {
            return super.func_176203_a(7).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true));
        }
        return super.func_176203_a(meta).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false));
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int age = this.func_185527_x(state);
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        ret.add(new ItemStack(this.func_180660_a(state, rand, fortune), 1, this.func_180651_a(state)));
        if (age >= this.func_185526_g()) {
            int count = 1 + fortune;
            if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
                if (rand.nextInt(2 * this.func_185526_g()) <= age) {
                    ret.add(new ItemStack(this.func_149866_i(), count));
                }
            } else {
                ret.add(new ItemStack(this.func_149866_i(), 1));
            }
        }
        return ret;
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            return 8;
        }
        return super.func_176201_c(state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int meta = (Integer)state.func_177229_b((IProperty)field_176488_a);
        return meta > 6 ? this.func_149865_P() : this.func_149866_i();
    }
}

