/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.BWMod;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.api.tile.dispenser.IBehaviorCollect;
import betterwithmods.api.tile.dispenser.IBehaviorEntity;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.blocks.behaviors.BehaviorBreakBlock;
import betterwithmods.common.blocks.behaviors.BehaviorDefaultDispenseBlock;
import betterwithmods.common.blocks.behaviors.BehaviorEntity;
import betterwithmods.common.blocks.tile.TileEntityBlockDispenser;
import betterwithmods.util.InvUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockSourceImpl;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryDefaulted;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockBDispenser
extends BlockDispenser
implements IMultiVariants {
    public static final RegistryDefaulted<Item, IBehaviorDispenseItem> BLOCK_DISPENSER_REGISTRY = new RegistryDefaulted((Object)new BehaviorDefaultDispenseBlock());
    public static final RegistryDefaulted<Block, IBehaviorCollect> BLOCK_COLLECT_REGISTRY = new RegistryDefaulted((Object)new BehaviorBreakBlock());
    public static final RegistryDefaulted<ResourceLocation, IBehaviorEntity> ENTITY_COLLECT_REGISTRY = new RegistryDefaulted((Object)new BehaviorEntity());

    public BlockBDispenser() {
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_149711_c(3.5f);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public String[] getVariants() {
        return new String[]{"facing=north,triggered=false"};
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_175625_s(pos) != null) {
            player.openGui((Object)BWMod.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    private boolean isRedstonePowered(IBlockState state, World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos check;
            if (facing == state.func_177229_b((IProperty)BlockDirectional.field_176387_N) || world.func_175651_c(check = pos.func_177972_a(facing), facing) <= 0) continue;
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos other) {
        boolean flag = this.isRedstonePowered(state, world, pos);
        boolean flag1 = (Boolean)state.func_177229_b((IProperty)field_176440_b);
        if (flag && !flag1) {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
            world.func_180501_a(pos, state.func_177226_a((IProperty)field_176440_b, (Comparable)Boolean.valueOf(true)), 5);
        } else if (!flag && flag1) {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
            world.func_180501_a(pos, state.func_177226_a((IProperty)field_176440_b, (Comparable)Boolean.valueOf(false)), 5);
        }
    }

    private Optional<Entity> getEntity(World world, BlockPos pos) {
        return world.func_175647_a(Entity.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)), Entity::func_70089_S).stream().findFirst();
    }

    protected void func_176439_d(World world, BlockPos pos) {
        BlockSourceImpl impl = new BlockSourceImpl(world, pos);
        TileEntityBlockDispenser tile = (TileEntityBlockDispenser)impl.func_150835_j();
        if (!((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)field_176440_b)).booleanValue()) {
            Optional<Entity> entity;
            BlockPos check = pos.func_177972_a((EnumFacing)impl.func_189992_e().func_177229_b((IProperty)field_176441_a));
            Block block = world.func_180495_p(check).func_177230_c();
            if (world.func_180495_p(check).func_185887_b(world, check) < 0.0f) {
                return;
            }
            IBehaviorCollect behavior = (IBehaviorCollect)BLOCK_COLLECT_REGISTRY.func_82594_a((Object)block);
            if (!world.func_175623_d(check) || !block.func_176200_f((IBlockAccess)world, check)) {
                NonNullList<ItemStack> stacks = behavior.collect((IBlockSource)new BlockSourceImpl(world, check));
                InvUtils.insert((IItemHandler)tile.inventory, stacks, false);
            }
            if ((entity = this.getEntity(world, check)).isPresent()) {
                Entity e = entity.get();
                ResourceLocation name = EntityList.func_191301_a((Entity)e);
                IBehaviorEntity behaviorEntity = (IBehaviorEntity)ENTITY_COLLECT_REGISTRY.func_82594_a((Object)name);
                NonNullList<ItemStack> stacks = behaviorEntity.collect(world, check, e, tile.getCurrentSlot());
                InvUtils.insert((IItemHandler)tile.inventory, stacks, false);
            }
        } else {
            int index = tile.nextIndex;
            ItemStack stack = tile.getNextStackFromInv();
            if (index == -1 || stack.func_190926_b()) {
                world.func_175718_b(1001, pos, 0);
            } else {
                IBehaviorDispenseItem behavior = this.func_149940_a(stack);
                if (behavior != null) {
                    behavior.func_82482_a((IBlockSource)impl, stack);
                }
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityBlockDispenser) {
            InvUtils.ejectInventoryContents(world, pos, (IItemHandler)((TileEntityBlockDispenser)te).inventory);
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    protected IBehaviorDispenseItem func_149940_a(@Nullable ItemStack stack) {
        return (IBehaviorDispenseItem)BLOCK_DISPENSER_REGISTRY.func_82594_a((Object)(stack == null ? null : stack.func_77973_b()));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBlockDispenser();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return InvUtils.calculateComparatorLevel((IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
        return 0;
    }
}

