/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.container.other;

import betterwithmods.common.blocks.tile.FilteredStackHandler;
import betterwithmods.common.blocks.tile.SimpleStackHandler;
import betterwithmods.common.blocks.tile.TileEntityInfernalEnchanter;
import betterwithmods.common.items.ItemArcaneScroll;
import betterwithmods.util.InfernalEnchantment;
import betterwithmods.util.InvUtils;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerInfernalEnchanter
extends Container {
    public static final int INV_LAST = 1;
    public int[] enchantLevels;
    public int xpSeed;
    public int bookcaseCount;
    private TileEntityInfernalEnchanter tile;
    private SimpleStackHandler handler;

    public ContainerInfernalEnchanter(EntityPlayer player, TileEntityInfernalEnchanter tile) {
        int i;
        this.tile = tile;
        this.enchantLevels = new int[5];
        this.bookcaseCount = tile.getBookcaseCount();
        this.handler = new FilteredStackHandler(2, tile, new Predicate[]{stack -> stack.func_77973_b() instanceof ItemArcaneScroll, stack -> true}){

            @Override
            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ContainerInfernalEnchanter.this.onContextChanged((IItemHandler)this);
            }
        };
        this.xpSeed = player.func_175138_ci();
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler, 0, 17, 37));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler, 1, 17, 75));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandler(playerInv, j + i * 9 + 9, 8 + j * 18, 129 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(playerInv, i, 8 + i * 18, 187));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        switch (id) {
            default: {
                if (id >= this.enchantLevels.length) break;
                this.enchantLevels[id] = data;
                break;
            }
            case 3: {
                this.xpSeed = data;
                break;
            }
            case 4: {
                this.bookcaseCount = data;
            }
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            this.broadcastData(listener);
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.broadcastData(listener);
    }

    public void broadcastData(IContainerListener listener) {
        for (int i = 0; i < this.enchantLevels.length; ++i) {
            listener.func_71112_a((Container)this, i, this.enchantLevels[i]);
        }
        listener.func_71112_a((Container)this, 3, this.xpSeed & 0xFFFFFFF0);
        listener.func_71112_a((Container)this, 4, this.tile.getBookcaseCount());
    }

    public boolean areValidItems(ItemStack scroll, ItemStack item) {
        if (!scroll.func_190926_b() && !item.func_190926_b()) {
            InfernalEnchantment enchantment = new InfernalEnchantment(ItemArcaneScroll.getEnchantment(scroll));
            if (enchantment == null) {
                return false;
            }
            Set enchantments = EnchantmentHelper.func_82781_a((ItemStack)item).keySet();
            if (enchantments.contains((Object)enchantment)) {
                return false;
            }
            for (Enchantment e : enchantments) {
                if (e.func_191560_c((Enchantment)enchantment)) continue;
                return false;
            }
            if (item.func_77973_b().canApplyAtEnchantingTable(item, (Enchantment)enchantment)) {
                return true;
            }
        }
        return false;
    }

    public void onContextChanged(IItemHandler handler) {
        ItemStack item;
        ItemStack scroll = handler.getStackInSlot(0);
        if (this.areValidItems(scroll, item = handler.getStackInSlot(1))) {
            Enchantment enchantment = ItemArcaneScroll.getEnchantment(scroll);
            int enchantCount = EnchantmentHelper.func_82781_a((ItemStack)item).size();
            for (int levelIndex = 1; levelIndex <= this.enchantLevels.length; ++levelIndex) {
                this.enchantLevels[levelIndex - 1] = this.getEnchantCost(levelIndex, enchantment, enchantCount);
            }
        } else {
            Arrays.fill(this.enchantLevels, -1);
        }
        this.func_75142_b();
    }

    private int getEnchantCost(int levelIndex, Enchantment enchantment, int enchantCount) {
        if (enchantment == null || levelIndex > enchantment.func_77325_b()) {
            return -1;
        }
        double max = Math.min(enchantment.func_77325_b(), this.enchantLevels.length);
        double multiplier = (double)levelIndex / max;
        return (int)Math.ceil(30.0 * multiplier) + 30 * enchantCount;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index > 1 ? (itemstack1.func_77973_b() instanceof ItemArcaneScroll ? !this.func_75135_a(itemstack1, 0, 1, true) : !this.func_75135_a(itemstack1, 1, 2, true)) : !this.func_75135_a(itemstack1, 2, 37, true)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        this.handler.onContentsChanged(index);
        return itemstack;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack stack = this.handler.getStackInSlot(i);
            if (stack.func_190926_b() || playerIn.func_130014_f_().field_72995_K) continue;
            InvUtils.ejectStack(playerIn.func_130014_f_(), playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, stack);
        }
    }

    public boolean hasLevels(EntityPlayer player, int levelIndex) {
        return player.field_71075_bZ.field_75098_d || player.field_71068_ca >= this.enchantLevels[levelIndex];
    }

    public boolean hasBooks(int levelIndex) {
        return this.tile.getBookcaseCount() >= this.enchantLevels[levelIndex];
    }

    public boolean func_75140_a(EntityPlayer player, int levelIndex) {
        if (this.hasLevels(player, levelIndex) && this.hasBooks(levelIndex)) {
            if (!player.field_70170_p.field_72995_K) {
                ItemStack item = this.handler.getStackInSlot(1);
                ItemStack scroll = this.handler.getStackInSlot(0);
                Enchantment enchantment = ItemArcaneScroll.getEnchantment(scroll);
                if (enchantment != null) {
                    scroll.func_190918_g(1);
                    item.func_77966_a(enchantment, levelIndex + 1);
                    player.func_192024_a(item, this.enchantLevels[levelIndex]);
                    this.tile.func_145831_w().func_184133_a(null, this.tile.func_174877_v(), SoundEvents.field_187754_de, SoundCategory.BLOCKS, 1.0f, this.tile.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
                    this.onContextChanged((IItemHandler)this.handler);
                }
            }
            return true;
        }
        return false;
    }
}

