/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client;

import betterwithmods.BWMod;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraftforge.fml.common.Loader;

public class ResourceProxy
extends AbstractResourcePack {
    private static final String MINECRAFT = "minecraft";
    private static final Set<String> RESOURCE_DOMAINS = ImmutableSet.of((Object)"minecraft");
    private static final String BARE_FORMAT = "assets/%s/%s/%s/%s.%s";
    private static final String OVERRIDE_FORMAT = "/assets/%s/%s/%s/overrides/%s.%s";
    private static final Map<String, String> overrides = Maps.newHashMap();

    public ResourceProxy() {
        super(Loader.instance().activeModContainer().getSource());
        overrides.put("pack.mcmeta", "/proxypack.mcmeta");
    }

    public void addResource(String space, String domain, String dir, String file, String ext) {
        String bare = String.format(BARE_FORMAT, domain, space, dir, file, ext);
        String override = String.format(OVERRIDE_FORMAT, domain, space, dir, file, ext);
        overrides.put(bare, override);
        BWMod.logger.info("Override texture: {} to {}", (Object)bare, (Object)override);
    }

    public void addResource(String space, String dir, String file, String ext) {
        String bare = String.format(BARE_FORMAT, MINECRAFT, space, dir, file, ext);
        String override = String.format(OVERRIDE_FORMAT, "betterwithmods", space, dir, file, ext);
        overrides.put(bare, override);
        BWMod.logger.info("Override texture: {} to {}", (Object)bare, (Object)override);
    }

    public Set<String> func_110587_b() {
        return RESOURCE_DOMAINS;
    }

    protected InputStream func_110591_a(String name) throws IOException {
        if (name == null) {
            return null;
        }
        return BWMod.class.getResourceAsStream(overrides.get(name));
    }

    protected boolean func_110593_b(String name) {
        return overrides.containsKey(name);
    }

    public String func_130077_b() {
        return "bwm-texture-proxy";
    }
}

