/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.patchouli;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.UnaryOperator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.util.StringUtil;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellGrid;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.gui.GuiProgrammer;
import vazkii.psi.client.patchouli.PatchouliUtils;

public class SpellGridComponent
implements ICustomComponent {
    private transient SpellGrid grid;
    private transient String spellName;
    public IVariable spell;

    public void build(int componentX, int componentY, int pageNum) {
        try {
            String spellstr = this.spell.asString("");
            if (StringUtil.m_14408_((String)spellstr)) {
                throw new IllegalArgumentException("Spell string is missing!");
            }
            CompoundTag cmp = TagParser.m_129359_((String)spellstr);
            Spell fromNBT = Spell.createFromNBT(cmp);
            if (fromNBT == null) {
                throw new IllegalArgumentException("Invalid spell string: " + this.spell);
            }
            this.grid = fromNBT.grid;
            this.spellName = fromNBT.name;
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Invalid spell string: " + this.spell, e);
        }
    }

    public void render(GuiGraphics graphics, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        float scale = 0.65f;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(scale, scale, 0.0f);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280218_(GuiProgrammer.texture, 0, 0, 0, 0, 174, 184);
        graphics.m_280056_(context.getGui().getMinecraft().f_91062_, I18n.m_118938_((String)"psimisc.name", (Object[])new Object[0]), 7, 171, 0xFFFFFF, true);
        graphics.m_280056_(context.getGui().getMinecraft().f_91062_, this.spellName, 44, 170, 0xFFFFFF, true);
        graphics.m_280168_().m_252880_(7.0f, 7.0f, 0.0f);
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        this.grid.draw(graphics.m_280168_(), (MultiBufferSource)buffer, 0xF000F0);
        buffer.m_109911_();
        float scaledSize = 18.0f * scale;
        int scaledHoverSize = (int)(16.0f * scale);
        SpellPiece[][] gridData = this.grid.gridData;
        for (int i = 0; i < gridData.length; ++i) {
            SpellPiece[] data = gridData[i];
            for (int j = 0; j < data.length; ++j) {
                SpellPiece piece = data[j];
                if (piece == null || !context.isAreaHovered(mouseX, mouseY, (int)(4.0f + (float)i * scaledSize), (int)(4.0f + (float)j * scaledSize), scaledHoverSize, scaledHoverSize)) continue;
                PatchouliUtils.setPieceTooltip(context, piece);
            }
        }
        graphics.m_280168_().m_85849_();
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.spell = (IVariable)lookup.apply(this.spell);
    }
}

