/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.handler;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.psi.api.exosuit.PsiArmorEvent;
import vazkii.psi.client.core.handler.HUDHandler;
import vazkii.psi.client.core.handler.KeybindHandler;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageTriggerJumpSpell;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="psi")
public class ClientTickHandler {
    public static int ticksInGame = 0;
    public static float partialTicks = 0.0f;
    public static float delta = 0.0f;
    public static float total = 0.0f;
    private static boolean lastJumpKeyState = false;

    @OnlyIn(value=Dist.CLIENT)
    private static void calcDelta() {
        float oldTotal = total;
        total = (float)ticksInGame + partialTicks;
        delta = total - oldTotal;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            partialTicks = event.renderTickTime;
        } else {
            ClientTickHandler.calcDelta();
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.START) {
            boolean pressed = mc.f_91066_.f_92089_.m_90859_();
            if (mc.f_91074_ != null && pressed && !lastJumpKeyState && !mc.f_91074_.m_20096_()) {
                PsiArmorEvent.post(new PsiArmorEvent((Player)mc.f_91074_, "psi.event.jump"));
                MessageRegister.HANDLER.sendToServer((Object)new MessageTriggerJumpSpell());
            }
            lastJumpKeyState = pressed;
        }
        if (event.phase == TickEvent.Phase.END) {
            HUDHandler.tick();
            Screen gui = mc.f_91080_;
            if (gui == null && KeybindHandler.keybind.m_90857_()) {
                KeybindHandler.keyDown();
            }
            if (!mc.m_91104_()) {
                ++ticksInGame;
                partialTicks = 0.0f;
            }
            ClientTickHandler.calcDelta();
        }
    }
}

