/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.psi.api.recipe.ITrickRecipe;

public class TrickRecipeBuilder {
    private Ingredient input;
    private ItemStack output;
    private ItemStack cadAssembly;
    private ResourceLocation trick;

    private TrickRecipeBuilder(ItemStack output) {
        this.output = output;
    }

    public static TrickRecipeBuilder of(ItemStack output) {
        output.m_41764_(1);
        return new TrickRecipeBuilder(output);
    }

    public static TrickRecipeBuilder of(ItemLike output) {
        return new TrickRecipeBuilder(new ItemStack((ItemLike)output.m_5456_()));
    }

    public TrickRecipeBuilder input(Ingredient input) {
        this.input = input;
        return this;
    }

    public TrickRecipeBuilder input(ItemStack ... input) {
        this.input = Ingredient.m_43927_((ItemStack[])input);
        return this;
    }

    public TrickRecipeBuilder input(TagKey<Item> input) {
        this.input = Ingredient.m_204132_(input);
        return this;
    }

    public TrickRecipeBuilder input(ItemLike ... input) {
        this.input = Ingredient.m_43929_((ItemLike[])input);
        return this;
    }

    public TrickRecipeBuilder cad(ItemLike input) {
        this.cadAssembly = new ItemStack((ItemLike)input.m_5456_());
        return this;
    }

    public TrickRecipeBuilder cad(ItemStack input) {
        this.cadAssembly = input;
        return this;
    }

    public TrickRecipeBuilder trick(ResourceLocation trick) {
        this.trick = trick;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()));
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.output, this.input, this.cadAssembly, this.trick));
    }

    private static JsonObject serializeStack(ItemStack stack) {
        CompoundTag nbt = stack.m_41739_(new CompoundTag());
        byte c = nbt.m_128445_("Count");
        if (c != 1) {
            nbt.m_128344_("count", c);
        }
        nbt.m_128473_("Count");
        TrickRecipeBuilder.renameTag(nbt, "id", "item");
        TrickRecipeBuilder.renameTag(nbt, "tag", "nbt");
        Dynamic dyn = new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)nbt);
        return ((JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue()).getAsJsonObject();
    }

    private static void renameTag(CompoundTag nbt, String oldName, String newName) {
        Tag tag = nbt.m_128423_(oldName);
        if (tag != null) {
            nbt.m_128473_(oldName);
            nbt.m_128365_(newName, tag);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final Ingredient input;
        private final ItemStack output;
        private final ItemStack cadAssembly;
        private final ResourceLocation trick;
        private final ResourceLocation id;

        protected Result(ResourceLocation id, TrickRecipeBuilder builder) {
            this(id, builder.output, builder.input, builder.cadAssembly, builder.trick);
        }

        protected Result(ResourceLocation id, ItemStack output, Ingredient input, ItemStack cadAssembly, ResourceLocation trick) {
            this.input = input;
            this.output = output;
            this.cadAssembly = cadAssembly;
            this.trick = trick;
            this.id = id;
        }

        public void m_7917_(@Nonnull JsonObject json) {
            json.add("input", this.input.m_43942_());
            json.add("output", (JsonElement)TrickRecipeBuilder.serializeStack(this.output));
            json.add("cad", (JsonElement)TrickRecipeBuilder.serializeStack(this.cadAssembly));
            if (this.trick != null) {
                json.addProperty("trick", this.trick.toString());
            }
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return Objects.requireNonNull((RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(ITrickRecipe.TYPE_ID));
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

