/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler.capability;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.cad.IPsiBarDisplay;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.IPlayerData;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;

public class CADData
implements ICapabilityProvider,
ICADData,
ISpellAcceptor,
ISocketable,
IPsiBarDisplay {
    private final ItemStack cad;
    private int time;
    private int battery;
    private List<Vector3> vectors = Lists.newArrayList();
    private boolean dirty;
    private final LazyOptional<?> optional;

    public CADData(ItemStack cad) {
        this.cad = cad;
        this.optional = LazyOptional.of(() -> this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == PsiAPI.SOCKETABLE_CAPABILITY || capability == PsiAPI.CAD_DATA_CAPABILITY || capability == PsiAPI.PSI_BAR_DISPLAY_CAPABILITY || capability == PsiAPI.SPELL_ACCEPTOR_CAPABILITY) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void setTime(int time) {
        if (this.time != time) {
            this.time = time;
        }
    }

    @Override
    public int getBattery() {
        return this.battery;
    }

    @Override
    public void setBattery(int battery) {
        this.battery = battery;
    }

    @Override
    public Vector3 getSavedVector(int memorySlot) {
        if (this.vectors.size() <= memorySlot) {
            return Vector3.zero.copy();
        }
        Vector3 vec = this.vectors.get(memorySlot);
        return (vec == null ? Vector3.zero : vec).copy();
    }

    @Override
    public void setSavedVector(int memorySlot, Vector3 value) {
        while (this.vectors.size() <= memorySlot) {
            this.vectors.add(null);
        }
        this.vectors.set(memorySlot, value);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markDirty(boolean isDirty) {
        this.dirty = isDirty;
    }

    @Override
    public void setSpell(Player player, Spell spell) {
        int slot = this.getSelectedSlot();
        ItemStack bullet = this.getBulletInSocket(slot);
        if (!bullet.m_41619_() && ISpellAcceptor.isAcceptor(bullet)) {
            ISpellAcceptor.acceptor(bullet).setSpell(player, spell);
            this.setBulletInSocket(slot, bullet);
            player.m_36335_().m_41524_(this.cad.m_41720_(), 10);
        }
    }

    @Override
    public boolean requiresSneakForSpellSet() {
        return true;
    }

    @Override
    public boolean isSocketSlotAvailable(int slot) {
        int sockets = ((ICAD)this.cad.m_41720_()).getStatValue(this.cad, EnumCADStat.SOCKETS);
        if (sockets == -1 || sockets > 12) {
            sockets = 12;
        }
        return slot < sockets && slot >= 0;
    }

    @Override
    public ItemStack getBulletInSocket(int slot) {
        String name = "bullet" + slot;
        CompoundTag cmp = this.cad.m_41784_().m_128469_(name);
        if (cmp.m_128456_()) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)cmp);
    }

    @Override
    public void setBulletInSocket(int slot, ItemStack bullet) {
        String name = "bullet" + slot;
        CompoundTag cmp = new CompoundTag();
        if (!bullet.m_41619_()) {
            bullet.m_41739_(cmp);
        }
        this.cad.m_41784_().m_128365_(name, (Tag)cmp);
    }

    @Override
    public int getSelectedSlot() {
        return this.cad.m_41784_().m_128451_("selectedSlot");
    }

    @Override
    public void setSelectedSlot(int slot) {
        this.cad.m_41784_().m_128405_("selectedSlot", slot);
    }

    @Override
    public int getLastSlot() {
        int sockets = ((ICAD)this.cad.m_41720_()).getStatValue(this.cad, EnumCADStat.SOCKETS);
        if (sockets == -1 || sockets > 12) {
            sockets = 12;
        }
        return sockets - 1;
    }

    @Override
    public CompoundTag serializeForSynchronization() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("Time", this.time);
        compound.m_128405_("Battery", this.battery);
        return compound;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = this.serializeForSynchronization();
        ListTag memory = new ListTag();
        for (Vector3 vector : this.vectors) {
            if (vector == null) {
                memory.add((Object)new ListTag());
                continue;
            }
            ListTag vec = new ListTag();
            vec.add((Object)DoubleTag.m_128500_((double)vector.x));
            vec.add((Object)DoubleTag.m_128500_((double)vector.y));
            vec.add((Object)DoubleTag.m_128500_((double)vector.z));
            memory.add((Object)vec);
        }
        compound.m_128365_("Memory", (Tag)memory);
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_("Time", 99)) {
            this.time = nbt.m_128451_("Time");
        }
        if (nbt.m_128425_("Battery", 99)) {
            this.battery = nbt.m_128451_("Battery");
        }
        if (nbt.m_128425_("Memory", 9)) {
            ListTag memory = nbt.m_128437_("Memory", 9);
            ArrayList newVectors = Lists.newArrayList();
            for (int i = 0; i < memory.size(); ++i) {
                ListTag vec = (ListTag)memory.get(i);
                if (vec.m_7264_() == 6 && vec.size() >= 3) {
                    newVectors.add(new Vector3(vec.m_128772_(0), vec.m_128772_(1), vec.m_128772_(2)));
                    continue;
                }
                newVectors.add(null);
            }
            this.vectors = newVectors;
        }
    }

    @Override
    public boolean shouldShow(IPlayerData data) {
        return true;
    }
}

