/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.block.BlockProgrammer;
import vazkii.psi.common.spell.SpellCompiler;

public class TileProgrammer
extends BlockEntity {
    @ObjectHolder(registryName="minecraft:block_entity_type", value="psi:programmer")
    public static BlockEntityType<TileProgrammer> TYPE;
    private static final String TAG_SPELL = "spell";
    private static final String TAG_PLAYER_LOCK = "playerLock";
    public Spell spell;
    public boolean enabled;
    public String playerLock = "";

    public TileProgrammer(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public boolean isEnabled() {
        return this.spell != null && !this.spell.grid.isEmpty();
    }

    public boolean canCompile() {
        return this.isEnabled() && new SpellCompiler().compile(this.spell).left().isPresent();
    }

    public void onSpellChanged() {
        boolean wasEnabled = this.enabled;
        this.enabled = this.isEnabled();
        if (wasEnabled != this.enabled) {
            this.m_58904_().m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockProgrammer.ENABLED, (Comparable)Boolean.valueOf(this.enabled)));
        }
        this.m_6596_();
    }

    public void m_142466_(CompoundTag cmp) {
        super.m_142466_(cmp);
        this.readPacketNBT(cmp);
    }

    @Nonnull
    public void m_183515_(CompoundTag cmp) {
        super.m_183515_(cmp);
        CompoundTag spellCmp = new CompoundTag();
        if (this.spell != null) {
            this.spell.writeToNBT(spellCmp);
        }
        cmp.m_128365_(TAG_SPELL, (Tag)spellCmp);
        cmp.m_128359_(TAG_PLAYER_LOCK, this.playerLock);
    }

    public void readPacketNBT(CompoundTag cmp) {
        CompoundTag spellCmp = cmp.m_128469_(TAG_SPELL);
        if (this.spell == null) {
            this.spell = Spell.createFromNBT(spellCmp);
        } else {
            this.spell.readFromNBT(spellCmp);
        }
        this.playerLock = cmp.m_128461_(TAG_PLAYER_LOCK);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag cmp = new CompoundTag();
        this.m_183515_(cmp);
        return cmp;
    }

    public boolean canPlayerInteract(Player player) {
        return player.m_6084_() && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readPacketNBT(pkt.m_131708_());
    }
}

