/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.psi.api.internal.VanillaPacketDispatcher;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.block.tile.TileProgrammer;
import vazkii.psi.common.core.handler.PsiSoundHandler;

public class ItemSpellDrive
extends Item {
    private static final String TAG_SPELL = "spell";
    public static final String HAS_SPELL = "has_spell";

    public ItemSpellDrive(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @Nonnull
    public Component m_7626_(ItemStack stack) {
        String name = super.m_7626_(stack).getString();
        CompoundTag cmp = stack.m_41784_().m_128469_(TAG_SPELL);
        String spellName = cmp.m_128461_("spellName");
        if (spellName.isEmpty()) {
            return Component.m_237113_((String)name);
        }
        return Component.m_237113_((String)(name + " (" + ChatFormatting.GREEN + spellName + ChatFormatting.RESET + ")"));
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Player playerIn = ctx.m_43723_();
        InteractionHand hand = ctx.m_43724_();
        Level worldIn = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        ItemStack stack = playerIn.m_21120_(hand);
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof TileProgrammer) {
            TileProgrammer programmer = (TileProgrammer)tile;
            Spell spell = ItemSpellDrive.getSpell(stack);
            if (spell == null && programmer.canCompile()) {
                ItemSpellDrive.setSpell(stack, programmer.spell);
                if (!worldIn.f_46443_) {
                    worldIn.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, PsiSoundHandler.bulletCreate, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
            if (spell != null) {
                boolean enabled = programmer.isEnabled();
                if (enabled && !programmer.playerLock.isEmpty()) {
                    if (!programmer.playerLock.equals(playerIn.m_7755_().getString())) {
                        if (!worldIn.f_46443_) {
                            playerIn.m_213846_((Component)Component.m_237115_((String)"psimisc.not_your_programmer").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                        }
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    programmer.playerLock = playerIn.m_7755_().getString();
                }
                programmer.spell = spell;
                programmer.onSpellChanged();
                if (!worldIn.f_46443_) {
                    worldIn.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, PsiSoundHandler.bulletCreate, SoundSource.PLAYERS, 0.5f, 1.0f);
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(programmer);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand hand) {
        ItemStack itemStackIn = playerIn.m_21120_(hand);
        if (ItemSpellDrive.getSpell(itemStackIn) != null && playerIn.m_6144_()) {
            if (!worldIn.f_46443_) {
                worldIn.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), PsiSoundHandler.compileError, SoundSource.PLAYERS, 0.5f, 1.0f);
            } else {
                playerIn.m_6674_(hand);
            }
            ItemSpellDrive.setSpell(itemStackIn, null);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStackIn);
    }

    public static void setSpell(ItemStack stack, Spell spell) {
        CompoundTag cmp = new CompoundTag();
        if (spell != null) {
            spell.writeToNBT(cmp);
            stack.m_41784_().m_128365_(TAG_SPELL, (Tag)cmp);
            stack.m_41784_().m_128379_(HAS_SPELL, true);
        } else {
            stack.m_41784_().m_128473_(TAG_SPELL);
            stack.m_41784_().m_128473_(HAS_SPELL);
        }
    }

    public static Spell getSpell(ItemStack stack) {
        CompoundTag cmp = stack.m_41784_().m_128469_(TAG_SPELL);
        return Spell.createFromNBT(cmp);
    }
}

