/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.number;

import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceOperator;

public class PieceOperatorRoot
extends PieceOperator {
    SpellParam<Number> num;
    SpellParam<Number> root;

    public PieceOperatorRoot(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.num = new ParamNumber("psi.spellparam.number", SpellParam.GREEN, false, false);
        this.addParam(this.num);
        this.root = new ParamNumber("psi.spellparam.root", SpellParam.RED, false, false);
        this.addParam(this.root);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        double base = this.getParamValue(context, this.num).doubleValue();
        double r = this.getParamValue(context, this.root).doubleValue();
        if (base < 0.0 && r % 2.0 == 0.0) {
            throw new SpellRuntimeException("psi.spellerror.nthroot");
        }
        return Math.pow(base, 1.0 / r);
    }

    @Override
    public Class<?> getEvaluationType() {
        return Double.class;
    }
}

