/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.jei.tricks;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import vazkii.psi.api.recipe.ITrickRecipe;
import vazkii.psi.client.jei.tricks.DrawablePiece;
import vazkii.psi.common.item.base.ModItems;

public class TrickCraftingCategory
implements IRecipeCategory<ITrickRecipe> {
    public static final RecipeType<ITrickRecipe> TYPE = RecipeType.create((String)"psi", (String)"trick", ITrickRecipe.class);
    private static final int trickX = 43;
    private static final int trickY = 24;
    private final Map<ResourceLocation, IDrawable> trickIcons = new HashMap<ResourceLocation, IDrawable>();
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable programmerHover;
    private final IGuiHelper helper;

    public TrickCraftingCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(new ResourceLocation("psi", "textures/gui/jei/trick.png"), 0, 0, 96, 41);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.psidust));
        this.programmerHover = helper.createDrawable(new ResourceLocation("psi", "textures/gui/programmer.png"), 16, 184, 16, 16);
    }

    public RecipeType<ITrickRecipe> getRecipeType() {
        return TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237113_((String)I18n.m_118938_((String)"jei.psi.category.trick", (Object[])new Object[0]));
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(ITrickRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        if (recipe.getPiece() != null) {
            IDrawable trickIcon = this.trickIcons.computeIfAbsent(recipe.getPiece().registryKey, key -> new DrawablePiece(recipe.getPiece()));
            trickIcon.draw(poseStack, 43, 24);
            if (TrickCraftingCategory.onTrick(mouseX, mouseY)) {
                this.programmerHover.draw(poseStack, 43, 24);
            }
        }
    }

    @Nonnull
    public List<Component> getTooltipStrings(ITrickRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (recipe.getPiece() != null && TrickCraftingCategory.onTrick(mouseX, mouseY)) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            recipe.getPiece().getTooltip(tooltip);
            return tooltip;
        }
        return Collections.emptyList();
    }

    private static boolean onTrick(double mouseX, double mouseY) {
        return mouseX >= 43.0 && mouseX <= 59.0 && mouseY >= 24.0 && mouseY <= 40.0;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ITrickRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 6).addIngredients(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.CATALYST, 22, 24).addItemStack(recipe.getAssembly());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 74, 6).addItemStack(recipe.m_8043_());
    }
}

