/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.jei.crafting;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.common.crafting.recipe.BulletToDriveRecipe;
import vazkii.psi.common.item.ItemSpellBullet;
import vazkii.psi.common.item.ItemSpellDrive;
import vazkii.psi.common.item.base.ModItems;

public class BulletToDriveExtension
implements ICraftingCategoryExtension {
    private final List<List<ItemStack>> inputs;
    private final BulletToDriveRecipe recipe;

    public BulletToDriveExtension(BulletToDriveRecipe recipe) {
        this.recipe = recipe;
        this.inputs = ImmutableList.of((Object)ImmutableList.of((Object)new ItemStack((ItemLike)ModItems.spellDrive)), Registry.f_122827_.m_123024_().filter(item -> item instanceof ItemSpellBullet).map(ItemStack::new).collect(Collectors.toList()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper helper, IFocusGroup focuses) {
        ItemStack drive = new ItemStack((ItemLike)ModItems.spellDrive);
        focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK).filter(focus -> ((ItemStack)focus.getTypedValue().getIngredient()).m_41720_() instanceof ItemSpellBullet).findFirst().map(focus -> (ItemStack)focus.getTypedValue().getIngredient()).flatMap(stack -> ISpellAcceptor.hasSpell(stack) ? Optional.ofNullable(ISpellAcceptor.acceptor(stack).getSpell()) : Optional.empty()).ifPresent(spell -> ItemSpellDrive.setSpell(drive, spell));
        helper.createAndSetInputs(builder, this.inputs, 0, 0);
        helper.createAndSetOutputs(builder, (List)ImmutableList.of((Object)drive));
    }

    public void drawInfo(int recipeWidth, int recipeHeight, PoseStack matrixStack, double mouseX, double mouseY) {
        Minecraft.m_91087_().f_91062_.m_92883_(matrixStack, I18n.m_118938_((String)"jei.psi.spell_copy", (Object[])new Object[0]), 57.0f, 46.0f, 0x808080);
    }

    public ResourceLocation getRegistryName() {
        return this.recipe.m_6423_();
    }
}

