/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.data;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.psi.api.recipe.TrickRecipeBuilder;
import vazkii.psi.common.Psi;
import vazkii.psi.common.crafting.recipe.DimensionTrickRecipe;
import vazkii.psi.common.item.base.ModItems;
import vazkii.psi.common.lib.LibResources;

public class PsiTrickRecipeGenerator
extends RecipeProvider {
    public PsiTrickRecipeGenerator(DataGenerator generator) {
        super(generator);
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        TrickRecipeBuilder.of((ItemLike)ModItems.psidust).input((TagKey<Item>)Tags.Items.DUSTS_REDSTONE).cad((ItemLike)ModItems.cadAssemblyIron).build(consumer);
        TrickRecipeBuilder.of(PatchouliAPI.get().getBookStack(LibResources.PATCHOULI_BOOK)).input(new ItemLike[]{Items.f_42517_}).cad((ItemLike)ModItems.cadAssemblyIron).build(consumer);
        TrickRecipeBuilder.of((ItemLike)ModItems.cadAssemblyPsimetal).input(new ItemLike[]{ModItems.cadAssemblyGold}).trick(Psi.location("trick_infusion")).cad((ItemLike)ModItems.cadAssemblyIron).build(consumer, Psi.location("gold_to_psimetal_assembly_upgrade"));
        TrickRecipeBuilder.of((ItemLike)ModItems.psimetal).input((TagKey<Item>)Tags.Items.INGOTS_GOLD).trick(Psi.location("trick_infusion")).cad((ItemLike)ModItems.cadAssemblyIron).build(consumer);
        TrickRecipeBuilder.of((ItemLike)ModItems.psigem).input((TagKey<Item>)Tags.Items.GEMS_DIAMOND).trick(Psi.location("trick_greater_infusion")).cad((ItemLike)ModItems.cadAssemblyPsimetal).build(consumer);
        TrickRecipeBuilder builder = TrickRecipeBuilder.of((ItemLike)ModItems.ebonySubstance).input((TagKey<Item>)ItemTags.f_13160_).trick(Psi.location("trick_ebony_ivory")).cad((ItemLike)ModItems.cadAssemblyPsimetal);
        PsiTrickRecipeGenerator.dimension(builder, consumer, ForgeRegistries.ITEMS.getKey((Object)ModItems.ebonySubstance), (ResourceKey<Level>)Level.f_46430_);
        builder = TrickRecipeBuilder.of((ItemLike)ModItems.ivorySubstance).input((TagKey<Item>)Tags.Items.GEMS_QUARTZ).trick(Psi.location("trick_ebony_ivory")).cad((ItemLike)ModItems.cadAssemblyPsimetal);
        PsiTrickRecipeGenerator.dimension(builder, consumer, ForgeRegistries.ITEMS.getKey((Object)ModItems.ivorySubstance), (ResourceKey<Level>)Level.f_46430_);
    }

    @Nonnull
    public String m_6055_() {
        return "Psi trick crafting recipes";
    }

    public static void dimension(TrickRecipeBuilder builder, Consumer<FinishedRecipe> parent, ResourceLocation id, ResourceKey<Level> dimensionKey) {
        parent.accept(new DimensionResult(id, builder, dimensionKey));
    }

    public static class DimensionResult
    extends TrickRecipeBuilder.Result {
        private final ResourceKey<Level> dimensionId;

        protected DimensionResult(ResourceLocation id, TrickRecipeBuilder builder, ResourceKey<Level> type) {
            super(id, builder);
            this.dimensionId = type;
        }

        @Override
        public void m_7917_(@Nonnull JsonObject json) {
            super.m_7917_(json);
            json.addProperty("dimension", this.dimensionId.m_135782_().toString());
        }

        @Override
        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return DimensionTrickRecipe.SERIALIZER;
        }
    }
}

