/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.network.message;

import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import vazkii.psi.common.Psi;

public class MessageVisualEffect {
    public static final int TYPE_CRAFT = 0;
    private final int color;
    private final double x;
    private final double y;
    private final double z;
    private final double width;
    private final double height;
    private final double offset;
    private final int effectType;

    public MessageVisualEffect(int color, double x, double y, double z, double width, double height, double offset, int effectType) {
        this.color = color;
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.height = height;
        this.offset = offset;
        this.effectType = effectType;
    }

    public MessageVisualEffect(FriendlyByteBuf buf) {
        this.color = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.width = buf.readDouble();
        this.height = buf.readDouble();
        this.offset = buf.readDouble();
        this.effectType = buf.m_130242_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.color);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.width);
        buf.writeDouble(this.height);
        buf.writeDouble(this.offset);
        buf.m_130130_(this.effectType);
    }

    public boolean receive(Supplier<NetworkEvent.Context> context) {
        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.color & 0xFF) / 255.0f;
        context.get().enqueueWork(() -> {
            Level world = Psi.proxy.getClientWorld();
            switch (this.effectType) {
                case 0: {
                    for (int i = 0; i < 5; ++i) {
                        double particleX = this.x + (Math.random() - 0.5) * 2.1 * this.width;
                        double particleY = this.y - this.offset;
                        double particleZ = this.z + (Math.random() - 0.5) * 2.1 * this.width;
                        float grav = -0.05f - (float)Math.random() * 0.01f;
                        Psi.proxy.sparkleFX(particleX, particleY, particleZ, r, g, b, grav, 3.5f, 15);
                        double m = 0.01;
                        double d3 = 10.0;
                        for (int j = 0; j < 3; ++j) {
                            double d0 = world.f_46441_.m_188583_() * m;
                            double d1 = world.f_46441_.m_188583_() * m;
                            double d2 = world.f_46441_.m_188583_() * m;
                            world.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.x + (double)world.f_46441_.m_188501_() * this.width * 2.0 - this.width - d0 * d3, this.y + (double)world.f_46441_.m_188501_() * this.height - d1 * d3, this.z + (double)world.f_46441_.m_188501_() * this.width * 2.0 - this.width - d2 * d3, d0, d1, d2);
                        }
                    }
                    break;
                }
            }
        });
        return true;
    }
}

