/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.network.PacketDistributor;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.CADStatEvent;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADAssembly;
import vazkii.psi.api.cad.ICADColorizer;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.recipe.ITrickRecipe;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.PieceGroupAdvancementComplete;
import vazkii.psi.api.spell.PreSpellCastEvent;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCastEvent;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.piece.PieceCraftingTrick;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.BlockProgrammer;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.core.handler.ConfigHandler;
import vazkii.psi.common.core.handler.ContributorSpellCircleHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.core.handler.capability.CADData;
import vazkii.psi.common.crafting.ModCraftingRecipes;
import vazkii.psi.common.item.base.ModItems;
import vazkii.psi.common.lib.LibPieceGroups;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageCADDataSync;
import vazkii.psi.common.network.message.MessageVisualEffect;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class ItemCAD
extends Item
implements ICAD {
    private static final String TAG_TIME_LEGACY = "time";
    private static final String TAG_STORED_PSI_LEGACY = "storedPsi";
    private static final String TAG_X_LEGACY = "x";
    private static final String TAG_Y_LEGACY = "y";
    private static final String TAG_Z_LEGACY = "z";
    private static final Pattern VECTOR_PREFIX_PATTERN = Pattern.compile("^storedVector(\\d+)$");
    private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*])|(?:ComputerCraft)$");

    public ItemCAD(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    private ICADData getCADData(ItemStack stack) {
        return (ICADData)stack.getCapability(PsiAPI.CAD_DATA_CAPABILITY).orElseGet(() -> new CADData(stack));
    }

    private ISocketable getSocketable(ItemStack stack) {
        return (ISocketable)stack.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).orElseGet(() -> new CADData(stack));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        CADData data = new CADData(stack);
        if (nbt != null && nbt.m_128425_("Parent", 10)) {
            data.deserializeNBT(nbt.m_128469_("Parent"));
        }
        return data;
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        stack.getCapability(PsiAPI.CAD_DATA_CAPABILITY).ifPresent(data -> nbt.m_128365_("CapabilityData", data.serializeNBT()));
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null) {
            stack.getCapability(PsiAPI.CAD_DATA_CAPABILITY).ifPresent(data -> data.deserializeNBT((Tag)nbt.m_128469_("CapabilityData")));
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entityIn, int itemSlot, boolean isSelected) {
        CompoundTag compound = stack.m_41784_();
        stack.getCapability(PsiAPI.CAD_DATA_CAPABILITY).ifPresent(data -> {
            if (compound.m_128425_(TAG_TIME_LEGACY, 99)) {
                data.setTime(compound.m_128451_(TAG_TIME_LEGACY));
                data.markDirty(true);
                compound.m_128473_(TAG_TIME_LEGACY);
            }
            if (compound.m_128425_(TAG_STORED_PSI_LEGACY, 99)) {
                data.setBattery(compound.m_128451_(TAG_STORED_PSI_LEGACY));
                data.markDirty(true);
                compound.m_128473_(TAG_STORED_PSI_LEGACY);
            }
            HashSet keys = new HashSet(compound.m_128431_());
            for (String key : keys) {
                Matcher matcher = VECTOR_PREFIX_PATTERN.matcher(key);
                if (!matcher.find()) continue;
                CompoundTag vec = compound.m_128469_(key);
                compound.m_128473_(key);
                int memory = Integer.parseInt(matcher.group(1));
                Vector3 vector = new Vector3(vec.m_128459_(TAG_X_LEGACY), vec.m_128459_(TAG_Y_LEGACY), vec.m_128459_(TAG_Z_LEGACY));
                data.setSavedVector(memory, vector);
            }
            if (entityIn instanceof ServerPlayer && data.isDirty()) {
                ServerPlayer player = (ServerPlayer)entityIn;
                MessageRegister.sendToPlayer(new MessageCADDataSync((ICADData)data), (Player)player);
                data.markDirty(false);
            }
        });
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level worldIn = ctx.m_43725_();
        InteractionHand hand = ctx.m_43724_();
        BlockPos pos = ctx.m_8083_();
        Player playerIn = ctx.m_43723_();
        ItemStack stack = playerIn.m_21120_(hand);
        Block block = worldIn.m_8055_(pos).m_60734_();
        return block == ModBlocks.programmer ? ((BlockProgrammer)block).setSpell(worldIn, pos, playerIn, stack) : InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand hand) {
        ItemStack dyeStack;
        ItemStack itemStackIn = playerIn.m_21120_(hand);
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(playerIn);
        ItemStack playerCad = PsiAPI.getPlayerCAD(playerIn);
        if (playerCad != itemStackIn) {
            if (!worldIn.f_46443_) {
                playerIn.m_213846_((Component)Component.m_237115_((String)"psimisc.multiple_cads").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            }
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)itemStackIn);
        }
        ISocketable sockets = this.getSocketable(playerCad);
        ItemStack bullet = sockets.getSelectedBullet();
        if (!this.getComponentInSlot(playerCad, EnumCADComponent.DYE).m_41619_() && ContributorSpellCircleHandler.isContributor(playerIn.m_7755_().getString().toLowerCase(Locale.ROOT)) && !((ICADColorizer)(dyeStack = this.getComponentInSlot(playerCad, EnumCADComponent.DYE)).m_41720_()).getContributorName(dyeStack).equalsIgnoreCase(playerIn.m_7755_().getString())) {
            ((ICADColorizer)dyeStack.m_41720_()).setContributorName(dyeStack, playerIn.m_7755_().getString());
            this.setCADComponent(playerCad, dyeStack);
        }
        boolean did = ItemCAD.cast(worldIn, playerIn, data, bullet, itemStackIn, 40, 25, 0.5f, ctx -> {
            ctx.castFrom = hand;
        }).isPresent();
        if (!data.overflowed && bullet.m_41619_() && this.craft(playerCad, playerIn, null)) {
            worldIn.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), PsiSoundHandler.cadShoot, SoundSource.PLAYERS, 0.5f, (float)(0.5 + Math.random() * 0.5));
            data.deductPsi(100, 60, true);
            if (!data.hasAdvancement(LibPieceGroups.FAKE_LEVEL_PSIDUST)) {
                MinecraftForge.EVENT_BUS.post((Event)new PieceGroupAdvancementComplete(null, playerIn, LibPieceGroups.FAKE_LEVEL_PSIDUST));
            }
            did = true;
        }
        return new InteractionResultHolder(did ? InteractionResult.CONSUME : InteractionResult.PASS, (Object)itemStackIn);
    }

    public static Optional<ArrayList<Entity>> cast(Level world, Player player, PlayerDataHandler.PlayerData data, ItemStack bullet, ItemStack cad, int cd, int particles, float sound, Consumer<SpellContext> predicate) {
        return ItemCAD.cast(world, player, data, bullet, cad, cd, particles, sound, predicate, 0);
    }

    public static Optional<ArrayList<Entity>> cast(Level world, Player player, PlayerDataHandler.PlayerData data, ItemStack bullet, ItemStack cad, int cd, int particles, float sound, Consumer<SpellContext> predicate, int reservoir) {
        if (!data.overflowed && data.getAvailablePsi() > 0 && !cad.m_41619_() && !bullet.m_41619_() && ISpellAcceptor.hasSpell(bullet) && ItemCAD.isTruePlayer((Entity)player)) {
            ISpellAcceptor spellContainer = ISpellAcceptor.acceptor(bullet);
            Spell spell = spellContainer.getSpell();
            SpellContext context = new SpellContext().setPlayer(player).setSpell(spell);
            if (predicate != null) {
                predicate.accept(context);
            }
            if (context.isValid()) {
                if (context.cspell.metadata.evaluateAgainst(cad)) {
                    int cost = Math.max(ItemCAD.getRealCost(cad, bullet, context.cspell.metadata.getStat(EnumSpellStat.COST)) - reservoir, 0);
                    PreSpellCastEvent event = new PreSpellCastEvent(cost, sound, particles, cd, spell, context, player, data, cad, bullet);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        String cancelMessage = event.getCancellationMessage();
                        if (cancelMessage != null && !cancelMessage.isEmpty()) {
                            player.m_213846_((Component)Component.m_237115_((String)cancelMessage).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                        }
                        return Optional.empty();
                    }
                    cd = event.getCooldown();
                    particles = event.getParticles();
                    sound = event.getSound();
                    cost = event.getCost();
                    spell = event.getSpell();
                    context = event.getContext();
                    if (cost > 0) {
                        data.deductPsi(cost, cd, true);
                    }
                    if (cost != 0 && sound > 0.0f) {
                        if (!world.f_46443_) {
                            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), PsiSoundHandler.cadShoot, SoundSource.PLAYERS, sound, (float)(0.5 + Math.random() * 0.5));
                        } else {
                            int color = Psi.proxy.getColorForCAD(cad);
                            float r = (float)PsiRenderHelper.r(color) / 255.0f;
                            float g = (float)PsiRenderHelper.g(color) / 255.0f;
                            float b = (float)PsiRenderHelper.b(color) / 255.0f;
                            for (int i = 0; i < particles; ++i) {
                                double x = player.m_20185_() + (Math.random() - 0.5) * 2.1 * (double)player.m_20205_();
                                double y = player.m_20186_() - player.m_6049_();
                                double z = player.m_20189_() + (Math.random() - 0.5) * 2.1 * (double)player.m_20205_();
                                float grav = -0.15f - (float)Math.random() * 0.03f;
                                Psi.proxy.sparkleFX(x, y, z, r, g, b, grav, 0.25f, 15);
                            }
                            double x = player.m_20185_();
                            double y = player.m_20186_() + (double)player.m_20192_() - 0.1;
                            double z = player.m_20189_();
                            Vector3 lookOrig = new Vector3(player.m_20154_());
                            for (int i = 0; i < 25; ++i) {
                                Vector3 look = lookOrig.copy();
                                double spread = 0.25;
                                look.x += (Math.random() - 0.5) * spread;
                                look.y += (Math.random() - 0.5) * spread;
                                look.z += (Math.random() - 0.5) * spread;
                                look.normalize().multiply(0.15);
                                Psi.proxy.sparkleFX(x, y, z, r, g, b, (float)look.x, (float)look.y, (float)look.z, 0.3f, 5);
                            }
                        }
                    }
                    ArrayList<Object> SpellEntities = new ArrayList();
                    if (!world.f_46443_) {
                        SpellEntities = spellContainer.castSpell(context);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent(spell, context, player, data, cad, bullet));
                    return Optional.of(SpellEntities);
                }
                if (!world.f_46443_) {
                    player.m_213846_((Component)Component.m_237115_((String)"psimisc.weak_cad").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean craft(ItemStack cad, Player player, PieceCraftingTrick craftingTrick) {
        Level world = player.f_19853_;
        if (world.f_46443_) {
            return false;
        }
        List items = player.m_20193_().m_6443_(ItemEntity.class, player.m_20191_().m_82400_(8.0), entity -> entity != null && entity.m_20280_((Entity)player) <= 64.0);
        CraftingWrapper inv = new CraftingWrapper();
        boolean did = false;
        for (ItemEntity item : items) {
            int count;
            int dropCount;
            Optional<ITrickRecipe> recipe;
            ItemStack stack = item.m_32055_();
            inv.setStack(stack);
            Predicate<ITrickRecipe> predicate = r -> r.getPiece() == null;
            if (craftingTrick != null) {
                predicate = r -> r.getPiece() == null || r.getPiece().canCraft(craftingTrick);
            }
            if (!(recipe = world.m_7465_().m_44015_(ModCraftingRecipes.TRICK_RECIPE_TYPE, (Container)inv, world).filter(predicate)).isPresent()) continue;
            ItemStack outCopy = recipe.get().m_8043_().m_41777_();
            for (count = stack.m_41613_() * outCopy.m_41613_(); count > 64; count -= dropCount) {
                dropCount = world.m_213780_().m_188503_(32) + 32;
                ItemEntity drop = new ItemEntity(world, item.m_20185_(), item.m_20186_(), item.m_20189_(), new ItemStack((ItemLike)outCopy.m_41720_(), dropCount));
                Vec3 motion = item.m_20184_();
                drop.m_20334_(motion.m_7096_() + ((double)world.m_213780_().m_188501_() - 0.5) / 5.0, motion.m_7098_() + (double)(world.m_213780_().m_188501_() / 10.0f), motion.m_7094_() + ((double)world.m_213780_().m_188501_() - 0.5) / 5.0);
                world.m_7967_((Entity)drop);
            }
            outCopy.m_41764_(count);
            item.m_32045_(outCopy);
            did = true;
            MessageVisualEffect msg = new MessageVisualEffect(1295871, item.m_20185_(), item.m_20186_(), item.m_20189_(), item.m_20205_(), item.m_20206_(), item.m_6049_(), 0);
            MessageRegister.HANDLER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> item), (Object)msg);
        }
        return did;
    }

    public static int getRealCost(ItemStack stack, ItemStack bullet, int cost) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof ICAD) {
            int eff = ((ICAD)stack.m_41720_()).getStatValue(stack, EnumCADStat.EFFICIENCY);
            if (eff == -1) {
                return -1;
            }
            if (eff == 0) {
                return cost;
            }
            double effPercentile = (double)eff / 100.0;
            double procCost = (double)cost / effPercentile;
            if (!bullet.m_41619_() && ISpellAcceptor.isContainer(bullet)) {
                procCost *= ISpellAcceptor.acceptor(bullet).getCostModifier();
            }
            return (int)procCost;
        }
        return cost;
    }

    public static boolean isTruePlayer(Entity e) {
        if (!(e instanceof Player)) {
            return false;
        }
        Player player = (Player)e;
        String name = player.m_7755_().getString();
        return !(player instanceof FakePlayer) && !FAKE_PLAYER_PATTERN.matcher(name).matches();
    }

    public static void setComponent(ItemStack stack, ItemStack componentStack) {
        if (stack.m_41720_() instanceof ICAD) {
            ((ICAD)stack.m_41720_()).setCADComponent(stack, componentStack);
        }
    }

    public static ItemStack makeCAD(ItemStack ... components) {
        return ItemCAD.makeCAD(Arrays.asList(components));
    }

    public static ItemStack makeCADWithAssembly(ItemStack assembly, List<ItemStack> components) {
        ItemStack cad = assembly.m_41720_() instanceof ICADAssembly ? ((ICADAssembly)assembly.m_41720_()).createCADStack(assembly, components) : new ItemStack((ItemLike)ModItems.cad);
        return ItemCAD.makeCAD(cad, components);
    }

    public static ItemStack makeCAD(List<ItemStack> components) {
        return ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cad), components);
    }

    public static ItemStack makeCAD(ItemStack base, List<ItemStack> components) {
        ItemStack stack = base.m_41777_();
        for (ItemStack component : components) {
            ItemCAD.setComponent(stack, component);
        }
        return stack;
    }

    @Override
    public ItemStack getComponentInSlot(ItemStack stack, EnumCADComponent type) {
        String name = "component" + type.name();
        CompoundTag cmp = stack.m_41784_().m_128469_(name);
        if (cmp.m_128456_()) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)cmp);
    }

    @Override
    public int getStatValue(ItemStack stack, EnumCADStat stat) {
        int statValue = 0;
        ItemStack componentStack = this.getComponentInSlot(stack, stat.getSourceType());
        if (!componentStack.m_41619_() && componentStack.m_41720_() instanceof ICADComponent) {
            ICADComponent component = (ICADComponent)componentStack.m_41720_();
            statValue = component.getCADStatValue(componentStack, stat);
        }
        CADStatEvent event = new CADStatEvent(stat, stack, componentStack, statValue);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getStatValue();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getSpellColor(ItemStack stack) {
        ItemStack dye = this.getComponentInSlot(stack, EnumCADComponent.DYE);
        if (!dye.m_41619_() && dye.m_41720_() instanceof ICADColorizer) {
            return ((ICADColorizer)dye.m_41720_()).getColor(dye);
        }
        return 1295871;
    }

    @Override
    public int getTime(ItemStack stack) {
        return this.getCADData(stack).getTime();
    }

    @Override
    public void incrementTime(ItemStack stack) {
        ICADData data = this.getCADData(stack);
        data.setTime(data.getTime() + 1);
    }

    @Override
    public int getStoredPsi(ItemStack stack) {
        int maxPsi = this.getStatValue(stack, EnumCADStat.OVERFLOW);
        return Math.min(this.getCADData(stack).getBattery(), maxPsi);
    }

    @Override
    public void regenPsi(ItemStack stack, int psi) {
        int maxPsi = this.getStatValue(stack, EnumCADStat.OVERFLOW);
        if (maxPsi == -1) {
            return;
        }
        int currPsi = this.getStoredPsi(stack);
        int endPsi = Math.min(currPsi + psi, maxPsi);
        if (endPsi != currPsi) {
            ICADData data = this.getCADData(stack);
            data.setBattery(endPsi);
            data.markDirty(true);
        }
    }

    @Override
    public int consumePsi(ItemStack stack, int psi) {
        if (psi == 0) {
            return 0;
        }
        int currPsi = this.getStoredPsi(stack);
        if (currPsi == -1) {
            return 0;
        }
        ICADData data = this.getCADData(stack);
        if (currPsi >= psi) {
            data.setBattery(currPsi - psi);
            data.markDirty(true);
            return 0;
        }
        data.setBattery(0);
        data.markDirty(true);
        return psi - currPsi;
    }

    @Override
    public int getMemorySize(ItemStack stack) {
        int vectors = this.getStatValue(stack, EnumCADStat.SAVED_VECTORS);
        if (vectors == -1) {
            return 255;
        }
        return vectors;
    }

    @Override
    public void setStoredVector(ItemStack stack, int memorySlot, Vector3 vec) throws SpellRuntimeException {
        int size = this.getMemorySize(stack);
        if (memorySlot < 0 || memorySlot >= size) {
            throw new SpellRuntimeException("psi.spellerror.memoryoutofbounds");
        }
        this.getCADData(stack).setSavedVector(memorySlot, vec);
    }

    @Override
    public Vector3 getStoredVector(ItemStack stack, int memorySlot) throws SpellRuntimeException {
        int size = this.getMemorySize(stack);
        if (memorySlot < 0 || memorySlot >= size) {
            throw new SpellRuntimeException("psi.spellerror.memoryoutofbounds");
        }
        return this.getCADData(stack).getSavedVector(memorySlot);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, @Nonnull BlockState state) {
        if (!PieceTrickBreakBlock.doingHarvestCheck.get().booleanValue()) {
            return super.isCorrectToolForDrops(stack, state);
        }
        int level = (Integer)ConfigHandler.COMMON.cadHarvestLevel.get();
        if (level >= 0) {
            return PieceTrickBreakBlock.canHarvest(level, state);
        }
        return false;
    }

    public void m_6787_(@Nonnull CreativeModeTab tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (!this.m_220152_(tab)) {
            return;
        }
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cadAssemblyIron)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cadAssemblyIron), new ItemStack((ItemLike)ModItems.cadCoreBasic), new ItemStack((ItemLike)ModItems.cadSocketBasic), new ItemStack((ItemLike)ModItems.cadBatteryBasic)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cadAssemblyGold), new ItemStack((ItemLike)ModItems.cadCoreBasic), new ItemStack((ItemLike)ModItems.cadSocketBasic), new ItemStack((ItemLike)ModItems.cadBatteryBasic)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cadAssemblyPsimetal), new ItemStack((ItemLike)ModItems.cadCoreOverclocked), new ItemStack((ItemLike)ModItems.cadSocketSignaling), new ItemStack((ItemLike)ModItems.cadBatteryExtended)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cadAssemblyEbony), new ItemStack((ItemLike)ModItems.cadCoreHyperClocked), new ItemStack((ItemLike)ModItems.cadSocketTransmissive), new ItemStack((ItemLike)ModItems.cadBatteryUltradense)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cadAssemblyIvory), new ItemStack((ItemLike)ModItems.cadCoreHyperClocked), new ItemStack((ItemLike)ModItems.cadSocketTransmissive), new ItemStack((ItemLike)ModItems.cadBatteryUltradense)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((ItemLike)ModItems.cadAssemblyCreative), new ItemStack((ItemLike)ModItems.cadCoreHyperClocked), new ItemStack((ItemLike)ModItems.cadSocketTransmissive), new ItemStack((ItemLike)ModItems.cadBatteryUltradense)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level playerin, List<Component> tooltip, TooltipFlag advanced) {
        TooltipHelper.tooltipIfShift(tooltip, () -> {
            Component componentName = ISocketable.getSocketedItemName(stack, "psimisc.none");
            tooltip.add((Component)Component.m_237110_((String)"psimisc.spell_selected", (Object[])new Object[]{componentName}));
            for (EnumCADComponent componentType : (EnumCADComponent[])EnumCADComponent.class.getEnumConstants()) {
                ItemStack componentStack = this.getComponentInSlot(stack, componentType);
                MutableComponent name = Component.m_237115_((String)"psimisc.none");
                if (!componentStack.m_41619_()) {
                    name = componentStack.m_41786_();
                }
                MutableComponent componentTypeName = Component.m_237115_((String)componentType.getName()).m_130940_(ChatFormatting.GREEN);
                tooltip.add((Component)componentTypeName.m_130946_(": ").m_7220_((Component)name));
                for (EnumCADStat stat : (EnumCADStat[])EnumCADStat.class.getEnumConstants()) {
                    if (stat.getSourceType() != componentType) continue;
                    String shrt = stat.getName();
                    int statVal = this.getStatValue(stack, stat);
                    Object statValStr = statVal == -1 ? "\u221e" : "" + statVal;
                    tooltip.add((Component)Component.m_237115_((String)shrt).m_130940_(ChatFormatting.AQUA).m_130946_(": " + (String)statValStr));
                }
            }
        });
    }

    @Nonnull
    public Rarity m_41460_(ItemStack stack) {
        return Rarity.RARE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_41656_(newStack);
    }

    private static class CraftingWrapper
    extends RecipeWrapper {
        CraftingWrapper() {
            super((IItemHandlerModifiable)new ItemStackHandler(1));
        }

        void setStack(ItemStack stack) {
            this.inv.setStackInSlot(0, stack);
        }
    }
}

