package vazkii.patchouli.common.multiblock;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.TriPredicate;

import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

public class StringStateMatcher {
	public static IStateMatcher fromString(String s) throws CommandSyntaxException {
		s = s.trim();
		if (s.equals("ANY")) {
			return StateMatcher.ANY;
		}
		if (s.equals("AIR")) {
			return StateMatcher.AIR;
		}

		// c.f. BlockPredicateArgument. Similar, but doesn't use vanilla's weird caching class.
		return class_2259.method_41962(class_7923.field_41175.method_46771(), s, true).map(
				blockResult -> new ExactMatcher(blockResult.comp_622(), blockResult.comp_623()),
				tagResult -> new TagMatcher(tagResult.comp_625(), tagResult.comp_626())
		);
	}

	private static class ExactMatcher implements IStateMatcher {
		private final class_2680 state;
		private final Map<class_2769<?>, Comparable<?>> props;

		private ExactMatcher(class_2680 state, Map<class_2769<?>, Comparable<?>> props) {
			this.state = state;
			this.props = props;
		}

		@Override
		public class_2680 getDisplayedState(long ticks) {
			return state;
		}

		@Override
		public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
			return (w, p, s) -> state.method_26204() == s.method_26204() && checkProps(s);
		}

		private boolean checkProps(class_2680 state) {
			for (Entry<class_2769<?>, Comparable<?>> e : props.entrySet()) {
				if (!state.method_11654(e.getKey()).equals(e.getValue())) {
					return false;
				}
			}
			return true;
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) {
				return true;
			}
			if (o == null || getClass() != o.getClass()) {
				return false;
			}
			ExactMatcher that = (ExactMatcher) o;
			return Objects.equals(state, that.state) &&
					Objects.equals(props, that.props);
		}

		@Override
		public int hashCode() {
			return Objects.hash(state, props);
		}
	}

	private static class TagMatcher implements IStateMatcher {
		private final class_6885<class_2248> tag;
		private final Map<String, String> props;

		private TagMatcher(class_6885<class_2248> tag, Map<String, String> props) {
			this.tag = tag;
			this.props = props;
		}

		@Override
		public class_2680 getDisplayedState(long ticks) {
			if (this.tag.method_40247() == 0) {
				return class_2246.field_9987.method_9564(); // show something impossible
			} else {
				int idx = (int) ((ticks / 20) % this.tag.method_40247());
				return this.tag.method_40240(idx).comp_349().method_9564();
			}
		}

		@Override
		public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
			return (w, p, s) -> s.method_40143(tag) && checkProps(s);
		}

		private boolean checkProps(class_2680 state) {
			for (Entry<String, String> entry : props.entrySet()) {
				class_2769<?> prop = state.method_26204().method_9595().method_11663(entry.getKey());
				if (prop == null) {
					return false;
				}

				Comparable<?> value = prop.method_11900(entry.getValue()).orElse(null);
				if (value == null) {
					return false;
				}

				if (!state.method_11654(prop).equals(value)) {
					return false;
				}
			}
			return true;
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) {
				return true;
			}
			if (o == null || getClass() != o.getClass()) {
				return false;
			}
			TagMatcher that = (TagMatcher) o;
			return Objects.equals(tag, that.tag) && Objects.equals(props, that.props);
		}

		@Override
		public int hashCode() {
			return Objects.hash(tag, props);
		}
	}
}
