package vazkii.patchouli.client.book.page;

import com.google.gson.annotations.SerializedName;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;

public class PageLink extends PageText {

	String url;
	@SerializedName("link_text") IVariable linkText;

	transient class_2561 realText;

	@Override
	public void build(class_1937 level, BookEntry entry, BookContentsBuilder builder, int pageNum) {
		super.build(level, entry, builder, pageNum);
		realText = linkText.as(class_2561.class);
	}

	@Override
	public void onDisplayed(GuiBookEntry parent, int left, int top) {
		super.onDisplayed(parent, left, top);

		addButton(class_4185.method_46430(i18nText(realText.getString()), (b) -> GuiBook.openWebLink(parent, url)).method_46433(GuiBook.PAGE_WIDTH / 2 - 50, GuiBook.PAGE_HEIGHT - 35).method_46437(100, 20).method_46431());
	}

}
