package vazkii.patchouli.client.book.page;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3956;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.page.abstr.PageDoubleRecipeRegistry;

public class PageCrafting extends PageDoubleRecipeRegistry<class_1860<?>> {

	public PageCrafting() {
		super(class_3956.field_17545);
	}

	@Override
	protected void drawRecipe(class_332 graphics, class_1860<?> recipe, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
		class_1937 level = class_310.method_1551().field_1687;
		if (level == null) {
			return;
		}

		RenderSystem.enableBlend();
		graphics.method_25290(book.craftingTexture, recipeX - 2, recipeY - 2, 0, 0, 100, 62, 128, 256);

		boolean shaped = recipe instanceof class_1869;
		if (!shaped) {
			int iconX = recipeX + 62;
			int iconY = recipeY + 2;
			graphics.method_25290(book.craftingTexture, iconX, iconY, 0, 64, 11, 11, 128, 256);
			if (parent.isMouseInRelativeRange(mouseX, mouseY, iconX, iconY, 11, 11)) {
				parent.setTooltip(class_2561.method_43471("patchouli.gui.lexicon.shapeless"));
			}
		}

		parent.drawCenteredStringNoShadow(graphics, getTitle(second).method_30937(), GuiBook.PAGE_WIDTH / 2, recipeY - 10, book.headerColor);

		parent.renderItemStack(graphics, recipeX + 79, recipeY + 22, mouseX, mouseY, recipe.method_8110(level.method_30349()));

		class_2371<class_1856> ingredients = recipe.method_8117();
		int wrap = 3;
		if (shaped) {
			wrap = ((class_1869) recipe).method_8150();
		}

		for (int i = 0; i < ingredients.size(); i++) {
			parent.renderIngredient(graphics, recipeX + (i % wrap) * 19 + 3, recipeY + (i / wrap) * 19 + 3, mouseX, mouseY, ingredients.get(i));
		}

		parent.renderItemStack(graphics, recipeX + 79, recipeY + 41, mouseX, mouseY, recipe.method_17447());
	}

	@Override
	protected int getRecipeHeight() {
		return 78;
	}

	@Override
	protected class_1799 getRecipeOutput(class_1937 level, class_1860<?> recipe) {
		if (recipe == null || level == null) {
			return class_1799.field_8037;
		}

		return recipe.method_8110(level.method_30349());
	}

}
