package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import org.lwjgl.glfw.GLFW;

import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.base.PersistentData.Bookmark;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.button.GuiButtonBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookArrow;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookBookmark;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookMarkRead;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.client.jei.PatchouliJeiPlugin;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.mixin.client.AccessorScreen;
import vazkii.patchouli.xplat.IXplatAbstractions;

import org.jetbrains.annotations.Nullable;

import java.awt.*;
import java.util.*;
import java.util.function.Predicate;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_6379;

public abstract class GuiBook extends class_437 {

	public static final int FULL_WIDTH = 272;
	public static final int FULL_HEIGHT = 180;
	public static final int PAGE_WIDTH = 116;
	public static final int PAGE_HEIGHT = 156;
	public static final int TOP_PADDING = 18;
	public static final int LEFT_PAGE_X = 15;
	public static final int RIGHT_PAGE_X = 141;
	public static final int TEXT_LINE_HEIGHT = 9;
	public static final int MAX_BOOKMARKS = 10;

	public final Book book;

	private static long lastSound;
	public int bookLeft, bookTop;
	private float scaleFactor;

	@Nullable private List<class_2561> tooltip;
	@Nullable private class_1799 tooltipStack;
	@Nullable private Pair<BookEntry, Integer> targetPage;
	protected int spread = 0, maxSpreads = 0;

	public int ticksInBook;
	public int maxScale;

	protected boolean needsBookmarkUpdate = false;

	public GuiBook(Book book, class_2561 title) {
		super(title);

		this.book = book;
	}

	@Override
	public void method_25426() {
		class_1041 res = field_22787.method_22683();
		double oldGuiScale = res.method_4476(field_22787.field_1690.method_42474().method_41753(), field_22787.method_1573());

		maxScale = getMaxAllowedScale();
		int persistentScale = Math.min(PersistentData.data.bookGuiScale, maxScale);
		double newGuiScale = res.method_4476(persistentScale, field_22787.method_1573());

		if (persistentScale > 0 && newGuiScale != oldGuiScale) {
			scaleFactor = (float) newGuiScale / (float) res.method_4495();

			res.method_15997(newGuiScale);
			field_22789 = res.method_4486();
			field_22790 = res.method_4502();
			res.method_15997(oldGuiScale);
		} else {
			scaleFactor = 1;
		}

		bookLeft = field_22789 / 2 - FULL_WIDTH / 2;
		bookTop = field_22790 / 2 - FULL_HEIGHT / 2;

		book.getContents().currentGui = this;

		method_37063(new GuiButtonBook(this, field_22789 / 2 - 9, bookTop + FULL_HEIGHT - 5, 308, 0, 18, 9, this::canSeeBackButton, this::handleButtonBack,
				class_2561.method_43471("patchouli.gui.lexicon.button.back"),
				class_2561.method_43471("patchouli.gui.lexicon.button.back.info").method_27692(class_124.field_1080)));
		method_37063(new GuiButtonBookArrow(this, bookLeft - 4, bookTop + FULL_HEIGHT - 6, true));
		method_37063(new GuiButtonBookArrow(this, bookLeft + FULL_WIDTH - 14, bookTop + FULL_HEIGHT - 6, false));

		addBookmarkButtons();
	}

	public class_310 getMinecraft() {
		return field_22787;
	}

	@Override
	public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
		graphics.method_51448().method_22903();
		if (scaleFactor != 1) {
			graphics.method_51448().method_22905(scaleFactor, scaleFactor, scaleFactor);

			mouseX /= scaleFactor;
			mouseY /= scaleFactor;
		}

		drawScreenAfterScale(graphics, mouseX, mouseY, partialTicks);
		graphics.method_51448().method_22909();
	}

	private void drawScreenAfterScale(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
		resetTooltip();

		graphics.method_51448().method_22903();
		graphics.method_51448().method_46416(bookLeft, bookTop, 0);
		graphics.method_51422(1F, 1F, 1F, 1F);
		drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
		drawForegroundElements(graphics, mouseX, mouseY, partialTicks);
		graphics.method_51448().method_22909();

		super.method_25394(graphics, mouseX, mouseY, partialTicks);

		IXplatAbstractions.INSTANCE.fireDrawBookScreen(this.book.id, this, mouseX, mouseY, partialTicks, graphics);

		drawTooltip(graphics, mouseX, mouseY);
	}

	@Override
	public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {

	}

	public void addBookmarkButtons() {
		removeDrawablesIf((b) -> b instanceof GuiButtonBookBookmark);

		int y = 0;
		List<Bookmark> bookmarks = PersistentData.data.getBookData(book).bookmarks;
		for (Bookmark bookmark : bookmarks) {
			method_37063(new GuiButtonBookBookmark(this, bookLeft + FULL_WIDTH, bookTop + TOP_PADDING + y, bookmark));
			y += 12;
		}

		if (shouldAddAddBookmarkButton() && bookmarks.size() <= MAX_BOOKMARKS) {
			method_37063(new GuiButtonBookBookmark(this, bookLeft + FULL_WIDTH, bookTop + TOP_PADDING + y, null));
		}

		if (MultiblockVisualizationHandler.hasMultiblock && MultiblockVisualizationHandler.bookmark != null) {
			method_37063(new GuiButtonBookBookmark(this, bookLeft + FULL_WIDTH, bookTop + TOP_PADDING + PAGE_HEIGHT - 20, MultiblockVisualizationHandler.bookmark, true));
		}

		if (shouldAddMarkReadButton()) {
			method_37063(new GuiButtonBookMarkRead(this, bookLeft + FULL_WIDTH, bookTop + TOP_PADDING + PAGE_HEIGHT - 10));
		}
	}

	public final void removeDrawablesIf(Predicate<class_4068> pred) {
		((AccessorScreen) (this)).getRenderables().removeIf(pred);
		method_25396().removeIf(listener -> listener instanceof class_4068 w && pred.test(w));
		((AccessorScreen) (this)).getNarratables().removeIf(listener -> listener instanceof class_4068 w && pred.test(w));
	}

	public final void removeDrawablesIn(Collection<?> coll) {
		removeDrawablesIf(coll::contains);
	}

	@Override // make public
	public <T extends class_364 & class_4068 & class_6379> T method_37063(T drawableElement) {
		return super.method_37063(drawableElement);
	}

	protected boolean shouldAddAddBookmarkButton() {
		return false;
	}

	protected boolean shouldAddMarkReadButton() {
		if (this instanceof GuiBookIndex) {
			return false;
		}
		return book.getContents().entries.values().stream().anyMatch(v -> !v.isLocked() && v.getReadState().equals(EntryDisplayState.UNREAD));
	}

	public void bookmarkThis() {
		// NO-OP
	}

	public void onFirstOpened() {
		// NO-OP
	}

	@Override
	public void method_25393() {
		if (!method_25442()) {
			ticksInBook++;
		}

		if (needsBookmarkUpdate) {
			needsBookmarkUpdate = false;
			addBookmarkButtons();
		}
	}

	final void drawBackgroundElements(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
		drawFromTexture(graphics, book, 0, 0, 0, 0, FULL_WIDTH, FULL_HEIGHT);
	}

	void drawForegroundElements(class_332 graphics, int mouseX, int mouseY, float partialTicks) {}

	final void drawTooltip(class_332 graphics, int mouseX, int mouseY) {
		if (tooltipStack != null) {
			List<class_2561> tooltip = class_437.method_25408(this.field_22787, tooltipStack);

			Pair<BookEntry, Integer> provider = book.getContents().getEntryForStack(tooltipStack);
			if (provider != null && (!(this instanceof GuiBookEntry) || ((GuiBookEntry) this).entry != provider.getFirst())) {
				class_2561 t = class_2561.method_43470("(")
						.method_10852(class_2561.method_43471("patchouli.gui.lexicon.shift_for_recipe"))
						.method_27693(")")
						.method_27692(class_124.field_1065);
				tooltip.add(t);
				targetPage = provider;
			}
			graphics.method_51434(this.field_22793, tooltip, mouseX, mouseY);
		} else if (tooltip != null && !tooltip.isEmpty()) {
			graphics.method_51434(this.field_22793, tooltip, mouseX, mouseY);
		}
	}

	final void resetTooltip() {
		tooltipStack = null;
		tooltip = null;
		targetPage = null;
	}

	public static void drawFromTexture(class_332 graphics, Book book, int x, int y, int u, int v, int w, int h) {
		graphics.method_25290(book.bookTexture, x, y, u, v, w, h, 512, 256);
	}

	@Override
	public boolean method_25421() {
		return book.pauseGame;
	}

	private void handleButtonBack(class_4185 button) {
		back(false);
	}

	public void handleButtonArrow(class_4185 button) {
		changePage(((GuiButtonBookArrow) button).left, false);
	}

	public void handleButtonBookmark(class_4185 button) {
		GuiButtonBookBookmark bookmarkButton = (GuiButtonBookBookmark) button;
		Bookmark bookmark = bookmarkButton.bookmark;
		if (bookmark == null || bookmark.getEntry(book) == null) {
			bookmarkThis();
		} else {
			if (method_25442() && !bookmarkButton.multiblock) {
				List<Bookmark> bookmarks = PersistentData.data.getBookData(book).bookmarks;
				bookmarks.remove(bookmark);
				PersistentData.save();
				needsBookmarkUpdate = true;
			} else {
				displayLexiconGui(new GuiBookEntry(book, bookmark.getEntry(book), bookmark.spread), true);
			}
		}
	}

	@Override
	public final boolean method_25402(double mouseX, double mouseY, int mouseButton) {
		return mouseClickedScaled(mouseX / scaleFactor, mouseY / scaleFactor, mouseButton);
	}

	public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
		switch (mouseButton) {
		case GLFW.GLFW_MOUSE_BUTTON_LEFT -> {
			if (targetPage != null && method_25442()) {
				displayLexiconGui(new GuiBookEntry(book, targetPage.getFirst(), targetPage.getSecond()), true);
				playBookFlipSound(book);
				return true;
			}
		}
		case GLFW.GLFW_MOUSE_BUTTON_RIGHT -> {
			back(true);
			return true;
		}
		case GLFW.GLFW_MOUSE_BUTTON_4 -> {
			changePage(true, true);
			return true;
		}
		case GLFW.GLFW_MOUSE_BUTTON_5 -> {
			changePage(false, true);
			return true;
		}
		}

		for (class_364 listener : method_25396()) {
			if (listener.method_25402(mouseX, mouseY, mouseButton)) {
				if (mouseButton == GLFW.GLFW_MOUSE_BUTTON_LEFT) {
					method_25398(true);
				}
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (class_310.method_1551().field_1690.field_1822.method_1417(keyCode, scanCode) && !this.canSeeBackButton()) {
			this.method_25419();
			return true;
		} else if (keyCode == GLFW.GLFW_KEY_BACKSPACE) {
			back(true);
			return true;
		} else if (tooltipStack != null && IXplatAbstractions.INSTANCE.handleRecipeKeybind(keyCode, scanCode, tooltipStack)) {
			return true;
		} else if (tooltipStack != null && IXplatAbstractions.INSTANCE.isModLoaded("jei")
				&& PatchouliJeiPlugin.handleRecipeKeybind(keyCode, scanCode, tooltipStack)) {
			return true;
		}
		return super.method_25404(keyCode, scanCode, modifiers);
	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
		if (scrollX < 0) {
			changePage(false, true);
		} else if (scrollX > 0) {
			changePage(true, true);
		}

		return true;
	}

	void back(boolean sfx) {
		if (!book.getContents().guiStack.isEmpty()) {
			if (method_25442()) {
				displayLexiconGui(new GuiBookLanding(book), false);
				book.getContents().guiStack.clear();
			} else {
				displayLexiconGui(book.getContents().guiStack.pop(), false);
			}

			if (sfx) {
				playBookFlipSound(book);
			}
		}
	}

	void changePage(boolean left, boolean sfx) {
		if (canSeePageButton(left)) {
			if (left) {
				spread--;
			} else {
				spread++;
			}

			onPageChanged();
			if (sfx) {
				playBookFlipSound(book);
			}
		}
	}

	void onPageChanged() {
		// NO-OP
	}

	public boolean canBeOpened() {
		return true;
	}

	public boolean canSeePageButton(boolean left) {
		return left ? spread > 0 : (spread + 1) < maxSpreads;
	}

	public boolean canSeeBackButton() {
		return !book.getContents().guiStack.isEmpty();
	}

	public void setTooltip(class_2561... strings) {
		setTooltip(Arrays.asList(strings));
	}

	public void setTooltip(List<class_2561> strings) {
		tooltip = strings;
	}

	public void setTooltipStack(class_1799 stack) {
		setTooltip(Collections.emptyList());
		tooltipStack = stack;
	}

	public boolean isMouseInRelativeRange(double absMx, double absMy, int x, int y, int w, int h) {
		double mx = getRelativeX(absMx);
		double my = getRelativeY(absMy);

		return mx > x && my > y && mx <= (x + w) && my <= (y + h);
	}

	/**
	 * Convert the given argument from global screen coordinates to local coordinates
	 */
	public double getRelativeX(double absX) {
		return absX - bookLeft;
	}

	/**
	 * Convert the given argument from global screen coordinates to local coordinates
	 */
	public double getRelativeY(double absY) {
		return absY - bookTop;
	}

	public void drawProgressBar(class_332 graphics, Book book, int mouseX, int mouseY, Predicate<BookEntry> filter) {
		if (!book.showProgress || !book.advancementsEnabled()) {
			return;
		}

		int barLeft = 19;
		int barTop = FULL_HEIGHT - 36;
		int barWidth = PAGE_WIDTH - 10;
		int barHeight = 12;

		int totalEntries = 0;
		int unlockedEntries = 0;

		int unlockedSecretEntries = 0;

		for (BookEntry entry : book.getContents().entries.values()) {
			if (filter.test(entry)) {
				if (entry.isSecret()) {
					if (!entry.isLocked()) {
						unlockedSecretEntries++;
					}
				} else {
					BookCategory category = entry.getCategory();
					if (category.isSecret() && !category.isLocked()) {
						continue;
					}

					totalEntries++;
					if (!entry.isLocked()) {
						unlockedEntries++;
					}
				}
			}
		}

		float unlockFract = (float) unlockedEntries / Math.max(1, (float) totalEntries);
		int progressWidth = (int) (((float) barWidth - 1) * unlockFract);

		graphics.method_25294(barLeft, barTop, barLeft + barWidth, barTop + barHeight, book.headerColor);

		drawGradient(graphics, barLeft + 1, barTop + 1, barLeft + barWidth - 1, barTop + barHeight - 1, book.progressBarBackground);
		drawGradient(graphics, barLeft + 1, barTop + 1, barLeft + progressWidth, barTop + barHeight - 1, book.progressBarColor);

		graphics.method_51439(this.field_22793, class_2561.method_43471("patchouli.gui.lexicon.progress_meter"), barLeft, barTop - 9, book.headerColor, false);

		if (isMouseInRelativeRange(mouseX, mouseY, barLeft, barTop, barWidth, barHeight)) {
			List<class_2561> tooltip = new ArrayList<>();
			class_2561 progressStr = class_2561.method_43469("patchouli.gui.lexicon.progress_tooltip", unlockedEntries, totalEntries);
			tooltip.add(progressStr);

			if (unlockedSecretEntries > 0) {
				if (unlockedSecretEntries == 1) {
					tooltip.add(class_2561.method_43471("patchouli.gui.lexicon.progress_tooltip.secret1").method_27692(class_124.field_1080));
				} else {
					tooltip.add(class_2561.method_43469("patchouli.gui.lexicon.progress_tooltip.secret", unlockedSecretEntries).method_27692(class_124.field_1080));
				}
			}

			if (unlockedEntries != totalEntries) {
				tooltip.add(class_2561.method_43471("patchouli.gui.lexicon.progress_tooltip.info").method_27692(class_124.field_1080));
			}

			setTooltip(tooltip);
		}
	}

	private void drawGradient(class_332 graphics, int x, int y, int w, int h, int color) {
		int darkerColor = new Color(color).darker().getRGB();
		graphics.method_25296(x, y, w, h, color, darkerColor);
	}

	public void drawCenteredStringNoShadow(class_332 graphics, class_5481 s, int x, int y, int color) {
		graphics.method_51430(field_22793, s, x - field_22793.method_30880(s) / 2, y, color, false);
	}

	public void drawCenteredStringNoShadow(class_332 graphics, String s, int x, int y, int color) {
		graphics.method_51433(field_22793, s, x - field_22793.method_1727(s) / 2, y, color, false);
	}

	private int getMaxAllowedScale() {
		return field_22787.method_22683().method_4476(0, field_22787.method_1573());
	}

	public int getSpread() {
		return spread;
	}

	public static void drawSeparator(class_332 graphics, Book book, int x, int y) {
		int w = 110;
		int h = 3;
		int rx = x + PAGE_WIDTH / 2 - w / 2;

		RenderSystem.enableBlend();
		graphics.method_51422(1F, 1F, 1F, 0.8F);
		drawFromTexture(graphics, book, rx, y, 140, 180, w, h);
		graphics.method_51422(1F, 1F, 1F, 1F);
	}

	public static void drawLock(class_332 graphics, Book book, int x, int y) {
		drawFromTexture(graphics, book, x, y, 250, 180, 16, 16);
	}

	public static void drawMarking(class_332 graphics, Book book, int x, int y, int rand, EntryDisplayState state) {
		if (!state.hasIcon) {
			return;
		}

		RenderSystem.enableBlend();
		//RenderSystem.disableAlphaTest();
		float alpha = state.hasAnimation ? ((float) Math.sin(ClientTicker.total * 0.2F) * 0.3F + 0.7F) : 1F;
		RenderSystem.setShaderColor(1F, 1F, 1F, alpha);
		drawFromTexture(graphics, book, x, y, state.u, 197, 8, 8);
		//RenderSystem.enableAlphaTest();
		RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
	}

	public static void drawPageFiller(class_332 graphics, Book book) {
		drawPageFiller(graphics, book, RIGHT_PAGE_X, TOP_PADDING);
	}

	public static void drawPageFiller(class_332 graphics, Book book, int x, int y) {
		RenderSystem.enableBlend();
		graphics.method_51422(1F, 1F, 1F, 1F);
		graphics.method_25290(book.fillerTexture, x + PAGE_WIDTH / 2 - 64, y + PAGE_HEIGHT / 2 - 74, 0, 0, 128, 128, 128, 128);
	}

	public static void playBookFlipSound(Book book) {
		if (ClientTicker.ticksInGame - lastSound > 6) {
			class_3414 sfx = PatchouliSounds.getSound(book.flipSound, PatchouliSounds.BOOK_FLIP);
			class_310.method_1551().method_1483().method_4873(class_1109.method_4758(sfx, (float) (0.7 + Math.random() * 0.3)));
			lastSound = ClientTicker.ticksInGame;
		}
	}

	public static void openWebLink(class_437 prevScreen, String address) {
		var mc = class_310.method_1551();
		mc.method_1507(new class_407(yes -> {
			if (yes) {
				class_156.method_668().method_670(address);
			}

			mc.method_1507(prevScreen);
		}, address, false));
	}

	public void displayLexiconGui(GuiBook gui, boolean push) {
		book.getContents().openLexiconGui(gui, push);
	}

}
