package vazkii.patchouli.fabric.network;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.network.MessageOpenBookGui;

import org.jetbrains.annotations.Nullable;

public class FabricMessageOpenBookGui {

	public static void send(class_3222 player, class_2960 book, @Nullable class_2960 entry, int page) {
		ServerPlayNetworking.send(player, new MessageOpenBookGui(book, entry, page));
	}

	public static void handle(MessageOpenBookGui message, ClientPlayNetworking.Context handler) {
		class_310 client = handler.client();
		client.method_20493(() -> ClientBookRegistry.INSTANCE.displayBookGui(message.book(), message.entry(), message.page()));
	}

}
