package vazkii.patchouli.fabric.common;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_1761;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import vazkii.patchouli.common.advancement.PatchouliCriteriaTriggers;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.command.OpenBookCommand;
import vazkii.patchouli.common.handler.LecternEventHandler;
import vazkii.patchouli.common.handler.ReloadContentsHandler;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.item.PatchouliDataComponents;
import vazkii.patchouli.common.item.PatchouliItems;
import vazkii.patchouli.network.MessageOpenBookGui;
import vazkii.patchouli.network.MessageReloadBookContents;

public class FabricModInitializer implements ModInitializer {
	@Override
	public void onInitialize() {
		PatchouliSounds.submitRegistrations((id, e) -> class_2378.method_10230(class_7923.field_41172, id, e));
		PatchouliDataComponents.submitDataComponentRegistrations((id, e) -> class_2378.method_10230(class_7923.field_49658, id, e));
		PatchouliItems.submitItemRegistrations((id, e) -> class_2378.method_10230(class_7923.field_41178, id, e));
		PatchouliCriteriaTriggers.submitTriggerRegistrations((id, e) -> class_2378.method_10230(class_7923.field_47496, id, e));
		FiberPatchouliConfig.setup();
		CommandRegistrationCallback.EVENT.register((disp, buildCtx, selection) -> OpenBookCommand.register(disp));
		UseBlockCallback.EVENT.register(LecternEventHandler::rightClick);

		PayloadTypeRegistry.playS2C().register(MessageOpenBookGui.TYPE, MessageOpenBookGui.CODEC);
		PayloadTypeRegistry.playS2C().register(MessageReloadBookContents.TYPE, MessageReloadBookContents.CODEC);

		BookRegistry.INSTANCE.init();

		ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, _r, success) -> {
			if (success) {
				ReloadContentsHandler.dataReloaded(server);
			}
		});

		BookRegistry.INSTANCE.books.values().forEach(b -> {
			if (!b.noBook) {
				if (b.creativeTab != null) {
					class_5321<class_1761> key = class_5321.method_29179(class_7924.field_44688, b.creativeTab);
					ItemGroupEvents.modifyEntriesEvent(key)
							.register(entries -> entries.method_45420(ItemModBook.forBook(b)));
				}
				ItemGroupEvents.modifyEntriesEvent(class_7706.field_40200).register(entries -> {
					entries.method_45420(ItemModBook.forBook(b));
				});
			}
		});
	}
}
