package vazkii.patchouli.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import vazkii.patchouli.api.IVariable;

import org.jetbrains.annotations.Nullable;

import java.util.Locale;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public final class SerializationUtil {

	public static final IVariable.Serializer VARIABLE_SERIALIZER = new IVariable.Serializer();
	public static final Gson RAW_GSON = new GsonBuilder()
			.registerTypeAdapter(class_2960.class, new class_2960.class_2961())
			.registerTypeAdapter(IVariable.class, VARIABLE_SERIALIZER)
			.create();
	public static final Gson PRETTY_GSON = new GsonBuilder().setPrettyPrinting().create();

	private SerializationUtil() {}

	public static class_2960 getAsResourceLocation(JsonObject object, String key, @Nullable class_2960 fallback) {
		if (object.has(key)) {
			return class_2960.method_12829(class_3518.method_15287(object.get(key), key));
		} else {
			return fallback;
		}
	}

	@Nullable
	public static <T extends Enum<T>> T getAsEnum(JsonObject object, String key, Class<T> clz, @Nullable T fallback) {
		if (object.has(key)) {
			var str = class_3518.method_15287(object.get(key), key).toUpperCase(Locale.ROOT);
			return Enum.valueOf(clz, str);
		} else {
			return fallback;
		}
	}
}
