package vazkii.patchouli.common.multiblock;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.TriPredicate;
import vazkii.patchouli.common.util.RotationUtil;

import java.util.*;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;

public class DenseMultiblock extends AbstractMultiblock {

	private final String[][] pattern;
	private IStateMatcher[][][] stateTargets;
	private final class_2382 size;

	public DenseMultiblock(String[][] pattern, Map<Character, IStateMatcher> targets) {
		this.pattern = pattern;
		this.size = build(targets, getPatternDimensions(pattern));
	}

	public DenseMultiblock(String[][] pattern, Object... targets) {
		this.pattern = pattern;
		this.size = build(targetsToMatchers(targets), getPatternDimensions(pattern));
	}

	@Override
	public Pair<class_2338, Collection<SimulateResult>> simulate(class_1937 world, class_2338 anchor, class_2470 rotation, boolean forView) {
		class_2338 disp = forView
				? new class_2338(-viewOffX, -viewOffY + 1, -viewOffZ).method_10070(rotation)
				: new class_2338(-offX, -offY, -offZ).method_10070(rotation);
		// the local origin of this multiblock, in world coordinates
		class_2338 origin = anchor.method_10081(disp);
		List<SimulateResult> ret = new ArrayList<>();
		for (int x = 0; x < size.method_10263(); x++) {
			for (int y = 0; y < size.method_10264(); y++) {
				for (int z = 0; z < size.method_10260(); z++) {
					class_2338 currDisp = new class_2338(x, y, z).method_10070(rotation);
					class_2338 actionPos = origin.method_10081(currDisp);
					char currC = pattern[y][x].charAt(z);
					ret.add(new SimulateResultImpl(actionPos, stateTargets[x][y][z], currC));
				}
			}
		}
		return Pair.of(origin, ret);
	}

	@Override
	public boolean test(class_1937 world, class_2338 start, int x, int y, int z, class_2470 rotation) {
		setWorld(world);
		if (x < 0 || y < 0 || z < 0 || x >= size.method_10263() || y >= size.method_10264() || z >= size.method_10260()) {
			return false;
		}
		class_2338 checkPos = start.method_10081(new class_2338(x, y, z).method_10070(RotationUtil.fixHorizontal(rotation)));
		TriPredicate<class_1922, class_2338, class_2680> pred = stateTargets[x][y][z].getStatePredicate();
		class_2680 state = world.method_8320(checkPos).method_26186(rotation);

		return pred.test(world, checkPos, state);
	}

	private static Map<Character, IStateMatcher> targetsToMatchers(Object... targets) {
		if (targets.length % 2 == 1) {
			throw new IllegalArgumentException("Illegal argument length for targets array " + targets.length);
		}
		Map<Character, IStateMatcher> stateMap = new HashMap<>();
		for (int i = 0; i < targets.length / 2; i++) {
			char c = (Character) targets[i * 2];
			Object o = targets[i * 2 + 1];
			IStateMatcher state;

			if (o instanceof class_2248) {
				state = StateMatcher.fromBlockLoose((class_2248) o);
			} else if (o instanceof class_2680) {
				state = StateMatcher.fromState((class_2680) o);
			} else if (o instanceof String) {
				try {
					state = StringStateMatcher.fromString((String) o);
				} catch (CommandSyntaxException e) {
					throw new RuntimeException(e);
				}
			} else if (o instanceof IStateMatcher) {
				state = (IStateMatcher) o;
			} else {
				throw new IllegalArgumentException("Invalid target " + o);
			}

			stateMap.put(c, state);
		}

		if (!stateMap.containsKey('_')) {
			stateMap.put('_', StateMatcher.ANY);
		}
		if (!stateMap.containsKey(' ')) {
			stateMap.put(' ', StateMatcher.AIR);
		}
		if (!stateMap.containsKey('0')) {
			stateMap.put('0', StateMatcher.AIR);
		}
		return stateMap;
	}

	private class_2382 build(Map<Character, IStateMatcher> stateMap, class_2382 dimensions) {
		boolean foundCenter = false;

		stateTargets = new IStateMatcher[dimensions.method_10263()][dimensions.method_10264()][dimensions.method_10260()];
		for (int y = 0; y < dimensions.method_10264(); y++) {
			for (int x = 0; x < dimensions.method_10263(); x++) {
				for (int z = 0; z < dimensions.method_10260(); z++) {
					char c = pattern[y][x].charAt(z);
					if (!stateMap.containsKey(c)) {
						throw new IllegalArgumentException("Character " + c + " isn't mapped");
					}

					IStateMatcher matcher = stateMap.get(c);
					if (c == '0') {
						if (foundCenter) {
							throw new IllegalArgumentException("A structure can't have two centers");
						}
						foundCenter = true;
						offX = x;
						offY = dimensions.method_10264() - y - 1;
						offZ = z;
						setViewOffset();
					}

					stateTargets[x][dimensions.method_10264() - y - 1][z] = matcher;
				}
			}
		}

		if (!foundCenter) {
			throw new IllegalArgumentException("A structure can't have no center");
		}
		return dimensions;
	}

	private static class_2382 getPatternDimensions(String[][] pattern) {
		int expectedLenX = -1;
		int expectedLenZ = -1;
		for (String[] arr : pattern) {
			if (expectedLenX == -1) {
				expectedLenX = arr.length;
			}
			if (arr.length != expectedLenX) {
				throw new IllegalArgumentException("Inconsistent array length. Expected" + expectedLenX + ", got " + arr.length);
			}

			for (String s : arr) {
				if (expectedLenZ == -1) {
					expectedLenZ = s.length();
				}
				if (s.length() != expectedLenZ) {
					throw new IllegalArgumentException("Inconsistent array length. Expected" + expectedLenX + ", got " + arr.length);
				}
			}
		}

		return new class_2382(expectedLenX, pattern.length, expectedLenZ);
	}

	@Override
	public class_2680 method_8320(class_2338 pos) {
		int x = pos.method_10263();
		int y = pos.method_10264();
		int z = pos.method_10260();
		if (x < 0 || y < 0 || z < 0 || x >= size.method_10263() || y >= size.method_10264() || z >= size.method_10260()) {
			return class_2246.field_10124.method_9564();
		}
		long ticks = world != null ? world.method_8510() : 0L;
		return stateTargets[x][y][z].getDisplayedState(ticks);
	}

	@Override
	public class_2382 getSize() {
		return size;
	}

	// These heights were assumed based being derivative of old behavior, but it may be ideal to change
	@Override
	public int method_31605() {
		return 255;
	}

	@Override
	public int method_31607() {
		return 0;
	}
}
