package vazkii.patchouli.common.item;

import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_7923;

public class ItemModBook extends class_1792 {

	public ItemModBook() {
		super(new class_1792.class_1793().method_7889(1));
	}

	public static float getCompletion(class_1799 stack) {
		Book book = getBook(stack);
		float progression = 0F; // default incomplete

		if (book != null) {
			int totalEntries = 0;
			int unlockedEntries = 0;

			for (BookEntry entry : book.getContents().entries.values()) {
				if (!entry.isSecret()) {
					totalEntries++;
					if (!entry.isLocked()) {
						unlockedEntries++;
					}
				}
			}

			progression = ((float) unlockedEntries) / Math.max(1f, (float) totalEntries);
		}

		return progression;
	}

	public static class_1799 forBook(Book book) {
		return forBook(book.id);
	}

	public static class_1799 forBook(class_2960 book) {
		class_1799 stack = new class_1799(PatchouliItems.BOOK);

		stack.method_57379(PatchouliDataComponents.BOOK, book);

		return stack;
	}

	// SoftImplement IForgeItem
	public String getCreatorModId(class_1799 stack) {
		var book = getBook(stack);
		if (book != null) {
			return book.owner.getId();
		}
		return class_7923.field_41178.method_10221(this).method_12836();
	}

	public static Book getBook(class_1799 stack) {
		class_2960 res = getBookId(stack);
		if (res == null) {
			return null;
		}
		return BookRegistry.INSTANCE.books.get(res);
	}

	private static class_2960 getBookId(class_1799 stack) {
		if (!stack.method_57826(PatchouliDataComponents.BOOK)) {
			return null;
		}

		return stack.method_57824(PatchouliDataComponents.BOOK);
	}

	@Override
	public class_2561 method_7864(class_1799 stack) {
		Book book = getBook(stack);
		if (book != null) {
			return class_2561.method_43471(book.name);
		}

		return super.method_7864(stack);
	}

	@Override
	public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 flagIn) {
		super.method_7851(stack, context, tooltip, flagIn);

		class_2960 rl = getBookId(stack);
		if (flagIn.method_8035()) {
			tooltip.add(class_2561.method_43470("Book ID: " + rl).method_27692(class_124.field_1080));
		}

		Book book = getBook(stack);
		if (book != null && !book.getContents().isErrored()) {
			tooltip.add(book.getSubtitle().method_27692(class_124.field_1080));
		} else if (book == null) {
			if (rl == null) {
				tooltip.add(class_2561.method_43471("item.patchouli.guide_book.undefined")
						.method_27692(class_124.field_1063));
			} else {
				tooltip.add(class_2561.method_43469("item.patchouli.guide_book.invalid", rl)
						.method_27692(class_124.field_1063));
			}
		}
	}

	@Override
	public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
		class_1799 stack = playerIn.method_5998(handIn);
		Book book = getBook(stack);
		if (book == null) {
			return new class_1271<>(class_1269.field_5814, stack);
		}

		if (playerIn instanceof class_3222) {
			PatchouliAPI.get().openBookGUI((class_3222) playerIn, book.id);

			// This plays the sound to others nearby, playing to the actual opening player handled from the packet
			class_3414 sfx = PatchouliSounds.getSound(book.openSound, PatchouliSounds.BOOK_OPEN);
			playerIn.method_5783(sfx, 1F, (float) (0.7 + Math.random() * 0.4));
		}

		return new class_1271<>(class_1269.field_5812, stack);
	}

}
