package vazkii.patchouli.client.gui;

import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.common.book.Book;

public class GuiButtonInventoryBook extends class_4185 {

	private final Book book;

	public GuiButtonInventoryBook(Book book, int x, int y) {
		super(x, y, 20, 20, class_2561.method_43473(), (b) -> {
			BookContents contents = book.getContents();
			contents.openLexiconGui(contents.getCurrentGui(), false);
		}, field_40754);
		this.book = book;
	}

	@Override
	public void method_48579(class_332 graphics, int mouseX, int mouseY, float pticks) {
		graphics.method_51422(1F, 1F, 1F, 1F);

		boolean hovered = mouseX >= method_46426() && mouseY >= method_46427() && mouseX < method_46426() + field_22758 && mouseY < method_46427() + field_22759;
		graphics.method_25290(class_2960.method_60655(PatchouliAPI.MOD_ID, "textures/gui/inventory_button.png"), method_46426(), method_46427(), (hovered ? 20 : 0), 0, field_22758, field_22759, 64, 64);

		class_1799 stack = book.getBookItem();
		graphics.method_51427(stack, method_46426() + 2, method_46427() + 2);
		graphics.method_51431(class_310.method_1551().field_1772, stack, method_46426() + 2, method_46427() + 2);

		EntryDisplayState readState = book.getContents().getReadState();
		if (readState.hasIcon && readState.showInInventory) {
			GuiBook.drawMarking(graphics, book, method_46426(), method_46427(), 0, readState);
		}
	}

	public Book getBook() {
		return book;
	}

}
