package vazkii.patchouli.client.book.page;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookArrowSmall;
import vazkii.patchouli.client.book.page.abstr.PageWithText;

public class PageImage extends PageWithText {

	class_2960[] images;
	String title;
	boolean border;

	transient int index;

	@Override
	public void onDisplayed(GuiBookEntry parent, int left, int top) {
		super.onDisplayed(parent, left, top);

		int x = 90;
		int y = 100;
		addButton(new GuiButtonBookArrowSmall(parent, x, y, true, () -> index > 0, this::handleButtonArrow));
		addButton(new GuiButtonBookArrowSmall(parent, x + 10, y, false, () -> index < images.length - 1, this::handleButtonArrow));
	}

	@Override
	public void render(class_332 graphics, int mouseX, int mouseY, float pticks) {

		int x = GuiBook.PAGE_WIDTH / 2 - 53;
		int y = 7;
		graphics.method_51422(1F, 1F, 1F, 1F);
		RenderSystem.enableBlend();
		graphics.method_51448().method_22905(0.5F, 0.5F, 0.5F);
		graphics.method_25302(images[index], x * 2 + 6, y * 2 + 6, 0, 0, 200, 200);
		graphics.method_51448().method_22905(2F, 2F, 2F);

		if (border) {
			GuiBook.drawFromTexture(graphics, book, x, y, 405, 149, 106, 106);
		}

		if (title != null && !title.isEmpty()) {
			parent.drawCenteredStringNoShadow(graphics, i18n(title), GuiBook.PAGE_WIDTH / 2, -3, book.headerColor);
		}

		if (images.length > 1 && border) {
			int xs = x + 83;
			int ys = y + 92;
			graphics.method_25294(xs, ys, xs + 20, ys + 11, 0x44000000);
			graphics.method_25294(xs - 1, ys - 1, xs + 20, ys + 11, 0x44000000);
		}

		super.render(graphics, mouseX, mouseY, pticks);
	}

	public void handleButtonArrow(class_4185 button) {
		boolean left = ((GuiButtonBookArrowSmall) button).left;
		if (left) {
			index--;
		} else {
			index++;
		}
	}

	@Override
	public int getTextHeight() {
		return 120;
	}

}
