package vazkii.patchouli.client.book.gui.button;

import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.gui.GuiBook;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_5250;

public class GuiButtonBookResize extends GuiButtonBook {
	public GuiButtonBookResize(GuiBook parent, int x, int y, class_4185.class_4241 onPress) {
		super(parent, x, y, 330, 9, 11, 11, onPress,
				class_2561.method_43471("patchouli.gui.lexicon.button.resize"));
	}

	@Override
	public List<class_2561> getTooltipLines() {
		var size = PersistentData.data.bookGuiScale;
		// The last size with a dedicated message. For sizes 6 and above, we display
		// verybig.message, wrapped in (scale - 5) iterations of verybig.container
		final int lastSize = 5;

		class_5250 sizeMsg;
		if (size <= lastSize) {
			sizeMsg = class_2561.method_43471("patchouli.gui.lexicon.button.resize.size" + size);
		} else {
			sizeMsg = class_2561.method_43471("patchouli.gui.lexicon.button.resize.verybig.message");
			for (int i = 0; i < size - lastSize; i++) {
				sizeMsg = class_2561.method_43469("patchouli.gui.lexicon.button.resize.verybig.container", sizeMsg);
			}
		}
		return Arrays.asList(tooltip.get(0), sizeMsg.method_27692(class_124.field_1080));
	}

}
