package vazkii.patchouli.client.base;

import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.mixin.client.AccessorClientAdvancements;

import org.jetbrains.annotations.NotNull;

import java.util.Map;
import net.minecraft.class_167;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_634;
import net.minecraft.class_8779;

public class ClientAdvancements {
	private static boolean gotFirstAdvPacket = false;

	/* Hooked at the end of ClientAdvancementManager.read, when the advancement packet arrives clientside
	The initial book load is done here when the first advancement packet arrives.
	Doing it anytime before that leads to excessive toast spam because the book believes everything to be locked,
	and then the first advancement packet unlocks everything.
	*/
	public static void onClientPacket() {
		if (!gotFirstAdvPacket) {
			ClientBookRegistry.INSTANCE.reload();
			gotFirstAdvPacket = true;
		} else {
			ClientBookRegistry.INSTANCE.reloadLocks(false);
		}
	}

	public static boolean hasDone(String advancement) {
		class_2960 id = class_2960.method_12829(advancement);
		if (id != null) {
			class_634 conn = class_310.method_1551().method_1562();
			if (conn != null) {
				net.minecraft.class_632 cm = conn.method_2869();
				class_8779 adv = cm.method_53815(id);
				if (adv != null) {
					Map<class_8779, class_167> progressMap = ((AccessorClientAdvancements) cm).getProgress();
					class_167 progress = progressMap.get(adv);
					return progress != null && progress.method_740();
				}
			}
		}
		return false;
	}

	public static void playerLogout() {
		gotFirstAdvPacket = false;
	}

	public static void sendBookToast(Book book) {
		class_374 gui = class_310.method_1551().method_1566();
		if (gui.method_1997(LexiconToast.class, book) == null) {
			gui.method_1999(new LexiconToast(book));
		}
	}

	public static class LexiconToast implements class_368 {
		private static final class_2960 BACKGROUND_SPRITE = class_2960.method_60656("toast/advancement");
		private final Book book;

		public LexiconToast(Book book) {
			this.book = book;
		}

		@NotNull
		@Override
		public Book method_1987() {
			return book;
		}

		@NotNull
		@Override
		public class_369 method_1986(class_332 graphics, class_374 toastGui, long delta) {
			graphics.method_52706(BACKGROUND_SPRITE, 0, 0, method_29049(), method_29050());

			class_327 font = toastGui.method_1995().field_1772;
			graphics.method_51439(font, class_2561.method_43471(book.name), 30, 7, 0xfff000f0, false);
			graphics.method_51439(font, class_2561.method_43471("patchouli.gui.lexicon.toast.info"), 30, 17, 0xffffffff, false);

			graphics.method_51427(book.getBookItem(), 8, 8);
			graphics.method_51431(font, book.getBookItem(), 8, 8);

			return delta >= 5000L ? class_368.class_369.field_2209 : class_368.class_369.field_2210;
		}

	}

}
