/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.function.UnaryOperator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.IVariablesAvailableCallback;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.template.TemplateInclusion;
import vazkii.patchouli.client.book.template.VariableAssigner;
import vazkii.patchouli.common.base.PatchouliConfig;

public abstract class TemplateComponent
implements IVariablesAvailableCallback {
    public String group = "";
    public int x;
    public int y;
    public String flag = "";
    public String advancement = "";
    @SerializedName(value="negate_advancement")
    boolean negateAdvancement = false;
    public String guard = null;
    transient boolean guardPass = false;
    transient boolean isVisible = true;
    private transient boolean compiled = false;
    public transient JsonObject sourceObject;

    public final void compile(Level level, IVariableProvider variables, IComponentProcessor processor, @Nullable TemplateInclusion encapsulation) {
        if (this.compiled) {
            return;
        }
        if (encapsulation != null) {
            this.x += encapsulation.x;
            this.y += encapsulation.y;
        }
        VariableAssigner.assignVariableHolders(level, this, variables, processor, encapsulation);
        this.compiled = true;
    }

    public boolean getVisibleStatus(IComponentProcessor processor) {
        if (processor != null && this.group != null && !this.group.isEmpty() && !processor.allowRender(this.group)) {
            return false;
        }
        if (!this.guardPass) {
            return false;
        }
        if (!this.flag.isEmpty() && !PatchouliConfig.getConfigFlag(this.flag)) {
            return false;
        }
        if (!this.advancement.isEmpty()) {
            return ClientAdvancements.hasDone(this.advancement) != this.negateAdvancement;
        }
        return true;
    }

    public void build(BookContentsBuilder builder, BookPage page, BookEntry entry, int pageNum) {
    }

    public void onDisplayed(BookPage page, GuiBookEntry parent, int left, int top) {
    }

    public void render(GuiGraphics graphics, BookPage page, int mouseX, int mouseY, float pticks) {
    }

    public boolean mouseClicked(BookPage page, double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    @Override
    public void onVariablesAvailable(UnaryOperator<IVariable> lookup, HolderLookup.Provider registries) {
        this.group = ((IVariable)lookup.apply(IVariable.wrap(this.group, registries))).asString();
        this.flag = ((IVariable)lookup.apply(IVariable.wrap(this.flag, registries))).asString();
        this.advancement = ((IVariable)lookup.apply(IVariable.wrap(this.advancement, registries))).asString();
        this.guardPass = this.guard == null || ((IVariable)lookup.apply(IVariable.wrap(this.guard, registries))).asBoolean();
    }
}

