package vazkii.patchouli.client.book.template.component;

import com.google.gson.annotations.SerializedName;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.template.TemplateComponent;

import java.util.function.UnaryOperator;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_7225;

public class ComponentHeader extends TemplateComponent {

	public IVariable text;

	@SerializedName("color") public IVariable colorStr;

	boolean centered = true;
	float scale = 1F;

	transient class_2561 actualText;
	transient int color;

	@Override
	public void build(BookContentsBuilder builder, BookPage page, BookEntry entry, int pageNum) {
		try {
			color = Integer.parseInt(colorStr.asString(""), 16);
		} catch (NumberFormatException e) {
			color = page.book.headerColor;
		}

		if (x == -1) {
			x = GuiBook.PAGE_WIDTH / 2;
		}
		if (y == -1) {
			y = 0;
		}
	}

	@Override
	public void render(class_332 graphics, BookPage page, int mouseX, int mouseY, float pticks) {
		graphics.method_51448().method_22903();
		graphics.method_51448().method_46416(x, y, 0);
		graphics.method_51448().method_22905(scale, scale, scale);

		if (centered) {
			page.parent.drawCenteredStringNoShadow(graphics, page.i18n(actualText.getString()), 0, 0, color);
		} else {
			graphics.method_51433(page.fontRenderer, page.i18n(actualText.getString()), 0, 0, color, false);
		}
		graphics.method_51448().method_22909();
	}

	@Override
	public void onVariablesAvailable(UnaryOperator<IVariable> lookup, class_7225.class_7874 registries) {
		super.onVariablesAvailable(lookup, registries);
		actualText = lookup.apply(text).as(class_2561.class);
		colorStr = lookup.apply(colorStr);
	}
}
