/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.book;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.api.PatchouliConfigAccess;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.util.ItemStackUtil;
import vazkii.patchouli.common.util.SerializationUtil;
import vazkii.patchouli.xplat.XplatModContainer;

public class Book {
    private static final String[] ORDINAL_SUFFIXES = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
    private static final ResourceLocation DEFAULT_MODEL = ResourceLocation.fromNamespaceAndPath((String)"patchouli", (String)"book_brown");
    private static final ResourceLocation DEFAULT_BOOK_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"patchouli", (String)"textures/gui/book_brown.png");
    private static final ResourceLocation DEFAULT_FILLER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"patchouli", (String)"textures/gui/page_filler.png");
    private static final ResourceLocation DEFAULT_CRAFTING_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"patchouli", (String)"textures/gui/crafting.png");
    private static final Map<String, String> DEFAULT_MACROS = (Map)Util.make(() -> {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("$(list", "$(li");
        ret.put("/$", "$()");
        ret.put("<br>", "$(br)");
        ret.put("$(item)", "$(#b0b)");
        ret.put("$(thing)", "$(#490)");
        return ret;
    });
    private BookContents contents;
    private boolean wasUpdated = false;
    public final XplatModContainer owner;
    public final ResourceLocation id;
    private Supplier<ItemStack> bookItem;
    public final int textColor;
    public final int headerColor;
    public final int nameplateColor;
    public final int linkColor;
    public final int linkHoverColor;
    public final int progressBarColor;
    public final int progressBarBackground;
    public final boolean isExternal;
    public final String name;
    public final String landingText;
    public final ResourceLocation bookTexture;
    public final ResourceLocation fillerTexture;
    public final ResourceLocation craftingTexture;
    public final ResourceLocation model;
    public final boolean useBlockyFont;
    public final ResourceLocation openSound;
    public final ResourceLocation flipSound;
    public final boolean showProgress;
    public final String indexIconRaw;
    public final String version;
    public final String subtitle;
    @Nullable
    public final ResourceLocation creativeTab;
    @Nullable
    public final ResourceLocation advancementsTab;
    public final boolean noBook;
    public final boolean showToasts;
    public final boolean pauseGame;
    public final boolean isPamphlet;
    public final boolean i18n;
    @Nullable
    public final PatchouliConfigAccess.TextOverflowMode overflowMode;
    public final Map<String, String> macros = new HashMap<String, String>();

    private static int parseColor(JsonObject root, String key, String defaultColor) {
        return 0xFF000000 | Integer.parseInt(GsonHelper.getAsString((JsonObject)root, (String)key, (String)defaultColor), 16);
    }

    public Book(JsonObject root, XplatModContainer owner, ResourceLocation id, boolean external) {
        this.name = GsonHelper.getAsString((JsonObject)root, (String)"name");
        this.landingText = GsonHelper.getAsString((JsonObject)root, (String)"landing_text", (String)"patchouli.gui.lexicon.landing_info");
        this.bookTexture = SerializationUtil.getAsResourceLocation(root, "book_texture", DEFAULT_BOOK_TEXTURE);
        this.fillerTexture = SerializationUtil.getAsResourceLocation(root, "filler_texture", DEFAULT_FILLER_TEXTURE);
        this.craftingTexture = SerializationUtil.getAsResourceLocation(root, "crafting_texture", DEFAULT_CRAFTING_TEXTURE);
        this.model = SerializationUtil.getAsResourceLocation(root, "model", DEFAULT_MODEL).withPrefix("item/");
        this.useBlockyFont = GsonHelper.getAsBoolean((JsonObject)root, (String)"use_blocky_font", (boolean)false);
        this.owner = owner;
        this.id = id;
        this.isExternal = external;
        this.textColor = Book.parseColor(root, "text_color", "000000");
        this.headerColor = Book.parseColor(root, "header_color", "333333");
        this.nameplateColor = Book.parseColor(root, "nameplate_color", "FFDD00");
        this.linkColor = Book.parseColor(root, "link_color", "0000EE");
        this.linkHoverColor = Book.parseColor(root, "link_hover_color", "8800EE");
        this.progressBarColor = Book.parseColor(root, "progress_bar_color", "FFFF55");
        this.progressBarBackground = Book.parseColor(root, "progress_bar_background", "DDDDDD");
        this.openSound = SerializationUtil.getAsResourceLocation(root, "open_sound", PatchouliSounds.BOOK_OPEN.getLocation());
        this.flipSound = SerializationUtil.getAsResourceLocation(root, "flip_sound", PatchouliSounds.BOOK_FLIP.getLocation());
        this.showProgress = GsonHelper.getAsBoolean((JsonObject)root, (String)"show_progress", (boolean)true);
        this.indexIconRaw = GsonHelper.getAsString((JsonObject)root, (String)"index_icon", (String)"");
        this.version = GsonHelper.getAsString((JsonObject)root, (String)"version", (String)"0");
        this.subtitle = GsonHelper.getAsString((JsonObject)root, (String)"subtitle", (String)"");
        this.creativeTab = SerializationUtil.getAsResourceLocation(root, "creative_tab", null);
        this.advancementsTab = SerializationUtil.getAsResourceLocation(root, "advancements_tab", null);
        this.noBook = GsonHelper.getAsBoolean((JsonObject)root, (String)"dont_generate_book", (boolean)false);
        this.showToasts = GsonHelper.getAsBoolean((JsonObject)root, (String)"show_toasts", (boolean)true);
        this.pauseGame = GsonHelper.getAsBoolean((JsonObject)root, (String)"pause_game", (boolean)false);
        this.isPamphlet = GsonHelper.getAsBoolean((JsonObject)root, (String)"pamphlet", (boolean)false);
        this.i18n = GsonHelper.getAsBoolean((JsonObject)root, (String)"i18n", (boolean)false);
        this.overflowMode = SerializationUtil.getAsEnum(root, "text_overflow_mode", PatchouliConfigAccess.TextOverflowMode.class, null);
        boolean useResourcePack = GsonHelper.getAsBoolean((JsonObject)root, (String)"use_resource_pack", (boolean)false);
        if (!this.isExternal && !useResourcePack) {
            String message = "Book %s has use_resource_pack set to false. ".formatted(this.id) + "This behaviour was removed in 1.20. The book author should enable this flag and move all book contents clientside to /assets/, leaving the book.json in /data/. See https://vazkiimods.github.io/Patchouli/docs/upgrading/upgrade-guide-120 for details.";
            throw new IllegalArgumentException(message);
        }
        ResourceLocation extensionTargetID = SerializationUtil.getAsResourceLocation(root, "extend", null);
        if (extensionTargetID != null) {
            String message = "Book %s is declared to extend %s. ".formatted(this.id, extensionTargetID) + "This behaviour was removed in 1.20. The author should simply ship the extra content they want to add or override in a resource pack.";
            throw new IllegalArgumentException(message);
        }
        String customBookItem = GsonHelper.getAsString((JsonObject)root, (String)"custom_book_item", (String)"");
        if (this.noBook) {
            Triple<Holder<Item>, DataComponentPatch, Integer> parsed = ItemStackUtil.deserializeStack(customBookItem, VanillaRegistries.createLookup());
            this.bookItem = Suppliers.memoize(() -> ItemStackUtil.loadFromParsed(parsed));
        } else {
            this.bookItem = Suppliers.memoize(() -> ItemModBook.forBook(id));
        }
        this.macros.putAll(DEFAULT_MACROS);
        for (Map.Entry e : GsonHelper.getAsJsonObject((JsonObject)root, (String)"macros", (JsonObject)new JsonObject()).entrySet()) {
            this.macros.put((String)e.getKey(), GsonHelper.convertToString((JsonElement)((JsonElement)e.getValue()), (String)"macro value"));
        }
    }

    public ItemStack getBookItem() {
        return this.bookItem.get();
    }

    public void markUpdated() {
        this.wasUpdated = true;
    }

    public boolean popUpdated() {
        boolean updated = this.wasUpdated;
        this.wasUpdated = false;
        return updated;
    }

    public void reloadContents(Level level, boolean singleBook) {
        try {
            this.contents = BookContentsBuilder.loadAndBuildFor(level, this, singleBook);
        }
        catch (Exception e) {
            PatchouliAPI.LOGGER.error("Error loading and compiling book {}, using empty contents", (Object)this.id, (Object)e);
            this.contents = BookContents.empty(this, e);
        }
    }

    public final boolean advancementsEnabled() {
        return !PatchouliConfig.get().disableAdvancementLocking() && !PatchouliConfig.get().noAdvancementBooks().contains(this.id.toString());
    }

    public void reloadLocks(boolean suppressToasts) {
        this.getContents().entries.values().forEach(BookEntry::updateLockStatus);
        this.getContents().categories.values().forEach(c -> c.updateLockStatus(true));
        boolean updated = this.popUpdated();
        if (updated && !suppressToasts && this.advancementsEnabled() && this.showToasts) {
            ClientAdvancements.sendBookToast(this);
        }
    }

    public String getOwnerName() {
        return this.owner.getName();
    }

    public Style getFontStyle() {
        if (this.useBlockyFont) {
            return Style.EMPTY;
        }
        return Style.EMPTY.withFont(Minecraft.UNIFORM_FONT);
    }

    public MutableComponent getSubtitle() {
        MutableComponent editionStr;
        try {
            int ver = Integer.parseInt(this.version);
            if (ver == 0) {
                return Component.translatable((String)this.subtitle);
            }
            editionStr = Component.literal((String)Book.numberToOrdinal(ver));
        }
        catch (NumberFormatException e) {
            editionStr = Component.translatable((String)"patchouli.gui.lexicon.dev_edition");
        }
        return Component.translatable((String)"patchouli.gui.lexicon.edition_str", (Object[])new Object[]{editionStr});
    }

    public BookIcon getIcon() {
        if (this.indexIconRaw == null || this.indexIconRaw.isEmpty()) {
            return new BookIcon.StackIcon(this.getBookItem());
        }
        return BookIcon.from(this.indexIconRaw);
    }

    private static String numberToOrdinal(int i) {
        return i % 100 == 11 || i % 100 == 12 || i % 100 == 13 ? i + "th" : i + ORDINAL_SUFFIXES[i % 10];
    }

    public BookContents getContents() {
        return this.contents != null ? this.contents : BookContents.empty(this, null);
    }
}

