package vazkii.patchouli.common.advancement;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

import net.minecraft.advancements.critereon.*;
import net.minecraft.class_2048;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import vazkii.patchouli.api.PatchouliAPI;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;

/**
 * An advancement trigger for opening Patchouli books.
 */
public class BookOpenTrigger extends class_4558<BookOpenTrigger.TriggerInstance> {
	public static final class_2960 ID = class_2960.method_60655(PatchouliAPI.MOD_ID, "open_book");
	public static final BookOpenTrigger INSTANCE = new BookOpenTrigger();

	@NotNull
	@Override
	public Codec<TriggerInstance> method_54937() {
		return BookOpenTrigger.TriggerInstance.CODEC;
	}

	public void trigger(@NotNull class_3222 player, @NotNull class_2960 book) {
		method_22510(player, instance -> instance.matches(book, null, 0));
	}

	public void trigger(@NotNull class_3222 player, @NotNull class_2960 book, @Nullable class_2960 entry, int page) {
		method_22510(player, instance -> instance.matches(book, entry, page));
	}

	public record TriggerInstance(Optional<class_5258> player, class_2960 book, Optional<class_2960> entry, class_2096.class_2100 page) implements SimpleInstance {

		public static Codec<BookOpenTrigger.TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group(
				class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::player),
				class_2960.field_25139.fieldOf("book").forGetter(TriggerInstance::book),
				class_2960.field_25139.optionalFieldOf("entry").forGetter(TriggerInstance::entry),
				class_2096.class_2100.field_45763.optionalFieldOf("page", class_2096.class_2100.field_9708).forGetter(TriggerInstance::page)
		).apply(instance, TriggerInstance::new));

		public boolean matches(@NotNull class_2960 book, @Nullable class_2960 entry, int page) {
			return this.book.equals(book) && (this.entry.isEmpty() || this.entry.get().equals(entry)) && this.page.method_9054(page);
		}
	}
}
