package vazkii.patchouli.xplat;

import vazkii.patchouli.api.PatchouliAPI;

import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5819;

public interface IClientXplatAbstractions {
	// NB: Fluids handled at callsite in platform-independent manner
	void renderForMultiblock(class_2680 state, class_2338 pos, class_1920 multiblock, class_4587 ps, class_4597 buffers, class_5819 rand);

	IClientXplatAbstractions INSTANCE = find();

	private static IClientXplatAbstractions find() {
		var providers = ServiceLoader.load(IClientXplatAbstractions.class, IClientXplatAbstractions.class.getClassLoader()).stream().toList();
		if (providers.size() != 1) {
			var names = providers.stream().map(p -> p.type().getName()).collect(Collectors.joining(",", "[", "]"));
			throw new IllegalStateException("There should be exactly one IClientXplatAbstractions implementation on the classpath. Found: " + names);
		} else {
			var provider = providers.get(0);
			PatchouliAPI.LOGGER.debug("Instantiating client xplat impl: " + provider.type().getName());
			return provider.get();
		}
	}
}
