package vazkii.patchouli.client.book;

import com.google.gson.JsonObject;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public abstract class BookPage {

	public transient class_310 mc;
	public transient class_327 fontRenderer;
	public transient GuiBookEntry parent;

	public transient Book book;
	protected transient BookEntry entry;
	protected transient int pageNum;
	private transient List<class_4185> buttons;
	public transient int left, top;
	public transient JsonObject sourceObject;

	protected String type, flag, advancement, anchor;

	public void build(class_1937 level, BookEntry entry, BookContentsBuilder builder, int pageNum) {
		this.book = entry.getBook();
		this.entry = entry;
		this.pageNum = pageNum;
	}

	public void onDisplayed(GuiBookEntry parent, int left, int top) {
		mc = parent.getMinecraft();
		book = parent.book;
		fontRenderer = mc.field_1772;
		this.parent = parent;
		this.left = left;
		this.top = top;
		buttons = new ArrayList<>();
	}

	public boolean isPageUnlocked() {
		return advancement == null || advancement.isEmpty() || ClientAdvancements.hasDone(advancement);
	}

	public void onHidden(GuiBookEntry parent) {
		parent.removeDrawablesIn(buttons);
	}

	protected void addButton(class_4185 button) {
		button.method_46421(button.method_46426() + (parent.bookLeft + left));
		button.method_46419(button.method_46427() + (parent.bookTop + top));
		buttons.add(button);
		parent.method_37063(button);
	}

	public void render(class_332 graphics, int mouseX, int mouseY, float pticks) {}

	public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
		return false;
	}

	public boolean canAdd(Book book) {
		return flag == null || flag.isEmpty() || PatchouliConfig.getConfigFlag(flag);
	}

	public String i18n(String text) {
		return book.i18n ? class_1074.method_4662(text) : text;
	}

	public class_2561 i18nText(String text) {
		return book.i18n ? class_2561.method_43471(text) : class_2561.method_43470(text);
	}
}
