package vazkii.patchouli.api;

import java.util.function.UnaryOperator;
import net.minecraft.class_2583;

/**
 * Represents a stack of styles when rendering book text.
 */
public interface IStyleStack {
	/** Modify the style at the top of the stack. */
	void modifyStyle(UnaryOperator<class_2583> f);

	/** Push a new style onto the style stack. */
	void pushStyle(class_2583 style);

	/** Pop the last style off the stack. Throws if called more times than pushStyle() was called. */
	class_2583 popStyle();

	/** Peek at the current style on the stack. */
	class_2583 peekStyle();

	/** Reset global style state. */
	void reset();
}
