package vazkii.patchouli.common.recipe;

import com.google.gson.JsonObject;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.PatchouliItems;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.BiFunction;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public record BookRecipeSerializer<T extends class_1860<?>, U extends T> (class_1865<T> compose, BiFunction<T, @Nullable class_2960, U> converter) implements class_1865<U> {
	@Override
	@NotNull
	public U method_8121(@NotNull class_2960 id, @NotNull JsonObject json) {
		if (!json.has("result")) {
			JsonObject object = new JsonObject();
			object.addProperty("item", PatchouliItems.BOOK_ID.toString());
			json.add("result", object);
		}
		T recipe = compose().method_8121(id, json);

		class_2960 outputBook = new class_2960(class_3518.method_15265(json, "book"));
		if (!BookRegistry.INSTANCE.books.containsKey(outputBook)) {
			PatchouliAPI.LOGGER.warn("Book {} in recipe {} does not exist!", outputBook, id);
		}

		return converter().apply(recipe, outputBook);
	}

	@Override
	@NotNull
	public U method_8122(@NotNull class_2960 id, @NotNull class_2540 buf) {
		T recipe = compose().method_8122(id, buf);
		return converter().apply(recipe, null);
	}

	@Override
	public void method_8124(@NotNull class_2540 buf, @NotNull U recipe) {
		compose().method_8124(buf, recipe);
	}
}
