package vazkii.patchouli.client.book.template.test;

import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class EntityTestProcessor implements IComponentProcessor {

	private String entityName;

	@Override
	public void setup(class_1937 level, IVariableProvider variables) {
		String entityType = variables.get("entity").unwrap().getAsString();
		if (entityType.contains("{")) {
			entityType = entityType.substring(0, entityType.indexOf("{"));
		}

		class_2960 key = new class_2960(entityType);
		entityName = class_7923.field_41177.method_17966(key)
				.map(class_1299::method_5897).map(class_2561::getString)
				.orElse(null);
	}

	@Override
	public IVariable process(class_1937 level, String key) {
		if (key.equals("name")) {
			return IVariable.wrap(entityName);
		}

		return null;
	}

}
