package vazkii.patchouli.client.book.page;

import net.minecraft.class_1074;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.page.abstr.PageWithText;

public class PageText extends PageWithText {

	String title;

	public void setText(String text) {
		this.text = IVariable.wrap(text);
	}

	@Override
	public int getTextHeight() {
		if (pageNum == 0) {
			return 22;
		}

		if (title != null && !title.isEmpty()) {
			return 12;
		}

		return -4;
	}

	@Override
	public void render(class_332 graphics, int mouseX, int mouseY, float pticks) {
		super.render(graphics, mouseX, mouseY, pticks);

		if (pageNum == 0) {
			boolean renderedSmol = false;
			String smolText = "";

			if (mc.field_1690.field_1827) {
				class_2960 res = parent.getEntry().getId();
				smolText = res.toString();
			} else if (entry.getAddedBy() != null) {
				smolText = class_1074.method_4662("patchouli.gui.lexicon.added_by", entry.getAddedBy());
			}

			if (!smolText.isEmpty()) {
				graphics.method_51448().method_22905(0.5F, 0.5F, 1F);
				parent.drawCenteredStringNoShadow(graphics, smolText, GuiBook.PAGE_WIDTH, 12, book.headerColor);
				graphics.method_51448().method_22905(2F, 2F, 1F);
				renderedSmol = true;
			}

			parent.drawCenteredStringNoShadow(graphics, parent.getEntry().getName().method_30937(), GuiBook.PAGE_WIDTH / 2, renderedSmol ? -3 : 0, book.headerColor);
			GuiBook.drawSeparator(graphics, book, 0, 12);
		} else if (title != null && !title.isEmpty()) {
			parent.drawCenteredStringNoShadow(graphics, i18n(title), GuiBook.PAGE_WIDTH / 2, 0, book.headerColor);
		}
	}

}
